Scriptname SuH_MCM extends SKI_ConfigBase

;	SuH_MCM : Mod Configuration Menu Script : is the script which generates and manages all MCM interactions. In conjunction with SuH_Status and SuH_Fun, this script allows the player to view status and alter the mod through custom leveling scripts or by changing settings.

;	External Scripts
SuH_Fun Property _f auto
SuH_Status Property _s auto

;	Menu Option IDs
	;	These ids are used as a universal variable for menu entries, replaced by whatever current menu we have selected. This method saves on memory usage but requires menual maintenance/tracking
int id0
int id1
int id2
int id3
int id4
int id5
int id6
int id7
int id8
int id9
int id10
int id11
int id12
int id13
int id14
int id15
int id16
int id17
int id18
int id19
int id20
int id21
int id22
int id23
int id24
int id25
int id26
int id27
int id28
int id29
int id30
int id31
int id32
int id33
int id34
int id35
int id36
int id37
int id38
int id39
int id40
int id41
int id42
int id43
int id44
int id45
int id46
;...up-to 127 (128 array cap)

;	Scrip Variables
;	ft= Feature Tutorial, set to 1 when tutorial has been displayed, held as script variables so they are displayed
int ftMCM
int ftstatus
int ftskill
int ftheart
int ftpassives
int ftactives
int ftsettings
int ftsoul
int fttitle
int fthelp
;	Pet Variables, held as script variables so they can be passed through multiple functions
int[] petslotarray ; Array for Pet Slot entries
bool[] petselectarray ; Selection array for which pet slot is selected
int petmenuoption ; Action selected, such as "Summon" or "Dismiss" 0=none 1=swap
int petselectedslot ; Pet Slot currently selected, defaults to first slot unless set otherwise
int petselectedslot2 ; Second slot selection used for slot swapping
int petdeletewarning ; number of warnings before deleting a pet

actor playerRef

;	OnInit
Event OnInit()
	parent.OnInit()
	InitProperties()
	MCMupdate()
endEvent

;	Init Properties
Function InitProperties()
	_f = Game.GetFormFromFile(0x814, "Succubus Heart.esp") as SuH_Fun
	_s = Game.GetFormFromFile(0x16E496, "Succubus Heart.esp") as SuH_Status
	playerRef = _s.playerRef
endFunction

;ent/ Init
Event OnConfigInit()
	ModName = "_Succubus Heart"
	Pages = new string[1]
		Pages[0] = "Initiate"
		Pages[1] = "Help"
endEvent

;	MCMupdate
Function MCMupdate()
	if _s.SuH_MCMversion == 0
		ModName = "_Succubus Heart"
		Pages = new string[1]
			Pages[0] = "Initiate"
			Pages[1] = "Help"
	elseIf _s.SuH_MCMversion < 5000008
		ModName = "_Succubus Heart"
		Pages = new string[9]
			Pages[0] = "Status"
			Pages[1] = "Heart Levels"
			Pages[2] = "Skill Levels"
			Pages[3] = "Passives"
			Pages[4] = "Actives"
			Pages[5] = "Soul Pets"
			Pages[6] = "Titles"
			Pages[7] = "Settings"
			Pages[8] = "Help"
		_s.SuH_MCMversion = 5000008
	endIf
endFunction

;	Passive Reset Cost Calc
int Function passiveresetcostcalc()
	int passiveresetcost = (playerref.GetLevel() * 200)
	if _s.SuH_SETfreepassivereset > 0
		passiveresetcost = 0
	endIf
	return passiveresetcost
endFunction

;	Set Status Display (Passives / Actives)
Function setstatusdisplay()
	SetTextOptionValue(id0, "H:"+_s.SuH_PCScaphealth+"  M:"+_s.SuH_PCScapmagicka+"  S:"+_s.SuH_PCScapstamina)
endFunction

;	OnPageReset
Event OnPageReset(string page)
	;	init variables
	playerRef = _s.playerRef

	if (page == "") ; Initial Page
		if ftMCM != 1 && _s.SuH_MCMversion != 0
			debug.MessageBox("< Welcome to the Succubus Heart MCM! > \n When entering each page for the first time you'll see a message like this explaining the page's functions. If you ever get lost check the 'Help' MCM page for more information then check the support Discord! \n << Don't forget to visit the Settings page to configure Succubus Heart's Features! >> \n Happy Draining!")
			ftMCM = 1
		endIf
        LoadCustomContent("SuH/SuH_cover.swf")
        return
    else
        UnloadCustomContent()
    endIf
	
	if (page == "Initiate") ; Initiate
		id0 = AddTextOption("Initiate ", "Start Succubus Heart ") ;Initiate
	endIf
	
	if (page == "Status") ; Status
	
		if ftstatus != 1
			debug.MessageBox("< Status > \n View key stats related to your Status, Succubus Abilities, and the mod's current state. Can also set overrides and lock various stats.")
			ftstatus = 1
		endIf
		
		;	Variables
		int modv = _s.SuH_MODversion
		int playerHealth = playerref.GetBaseActorValue("health") as int
		int playerMagicka = playerref.GetBaseActorValue("magicka") as int
		int playerStamina = playerref.GetBaseActorValue("stamina") as int
		int plvl = playerref.GetLevel() as int
		float x = _s.SuH_PCSarousal as float
		float y = _s.SuH_PCSarousaltarget as float
		int arousalpercentage = Math.Floor(((x + 1) / y) * 100)
		int effectivecap = (100 + ((6 + _s.SuH_PCScaplevel) * plvl))
		
		int healthCap = _s.SuH_PCScaphealth
		if healthcap > effectivecap
			healthCap = effectivecap
		endIf
		int magickaCap = _s.SuH_PCScapmagicka
		if magickaCap > effectivecap
			magickaCap = effectivecap
		endIf
		int staminaCap = _s.SuH_PCScapstamina
		if staminaCap > effectivecap
			staminaCap = effectivecap
		endIf
		
		bool SETdisablehealthrecovery = False
		if _s.SuH_SETdisablehealthrecovery > 0.0
			SETdisablehealthrecovery = True
		endIf
		
		bool SETdisablemagickarecovery = False
		if _s.SuH_SETdisablemagickarecovery > 0.0
			SETdisablemagickarecovery = True
		endIf
		
		bool SETdisablestaminarecovery = False
		if _s.SuH_SETdisablestaminarecovery > 0.0
			SETdisablestaminarecovery = True
		endIf
		
		if _s.SuH_framework == 1 ; SexLab
			_s.SuH_PCSgender = _s.SexLab.GetGender(playerref)
		elseif _s.SuH_framework == 2 ; OStim
			_s.PlayerRef.GetActorBase().GetSex()
		endIf
		
		string playerGender = "female"
		if _s.SuH_PCSgender != 1 && _s.SuH_PCSgender != 3
			playerGender = "male"
		endIf
		
		int sexbonusamount = 0
		if _s.SuH_PCSsexbonus > 0
			sexbonusamount = Math.Ceiling( ((_s.SuH_PCSsexbonus * 1.0) / _s.SuH_PCSsexbonushour) * 60.0 )
		endIf
		int fluidbonusamount = 0
		if _s.SuH_PCSfluidbonus > 0
			fluidbonusamount = Math.Ceiling( ((_s.SuH_PCSfluidbonus * 1.0) / _s.SuH_PCSfluidbonushour) * 60.0 )
		endIf
		
		string fworkstring = ""
		if _s.SuH_framework == 1
			fworkstring = "SexLab"
		elseif _s.SuH_framework == 2
			fworkstring = "OStim"
		endif
		
		string arousalstatetext = ""
		int arousalstate = _s.SuH_PCSarousalstate
		if arousalstate == 0
			arousalstatetext = "Exhausted"
		elseif arousalstate == 1
			arousalstatetext = "Normal"
		elseif arousalstate == 2
			arousalstatetext = "Craving"
		elseif arousalstate == 3
			arousalstatetext = "Withrawl"
		elseif arousalstate == 4
			arousalstatetext = "Starved"
		endIf
		
		bool carryfix = false
		bool carryfixsurvival = false
		if _s.SuH_SETcarrycorrect == 1
			carryfix = true
		elseif _s.SuH_SETcarrycorrect == 2
			carryfixsurvival = true
		endIf
		
		SetCursorFillMode(TOP_TO_BOTTOM); id23 - 29
		
		;	Left Side
		SetCursorPosition(0)
		
			AddHeaderOption("Status ") ; Status
			id0 = AddTextOption("Health ", playerHealth+"/"+healthCap+" ("+_s.SuH_PCScaphealth+")") ; healthcap
			id1 = AddTextOption("Magicka ", playerMagicka+"/"+magickaCap+" ("+_s.SuH_PCScapmagicka+")") ; magickacap
			id2 = AddTextOption("Stamina ", playerStamina+"/"+staminaCap+" ("+_s.SuH_PCScapstamina+")") ; staminacap
			id19 = AddTextOption("Effective Cap ", effectivecap) ; SuH_PCScaplevel
			id3 = AddTextOption("Sex Bonus ", sexbonusamount+"min (Game)") ; sexbonus
			id4 = AddTextOption("Fluid Bonus ", fluidbonusamount+"min (Game) ") ; fluidbonus
			AddEmptyOption()
			id15 = AddTextOption("Health Absorption Rating ", _s.SuH_PCSabsorbhealth) ; healthabsorprating
			id16 = AddTextOption("Magicka Absorption Rating ", _s.SuH_PCSabsorbmagicka) ; 
			id17 = AddTextOption("Stamina Absorption Rating ", _s.SuH_PCSabsorbstamina) ; 
			id18 = AddTextOption("Body "+_s.SuH_PCSbpoint+" : Desire "+_s.SuH_PCSdpoint+" : Soul "+_s.SuH_PCSspoint+" : Mind "+_s.SuH_PCSmpoint, " ") ; 
			AddEmptyOption()
			
			AddHeaderOption("Status Options ") ; Status
			id21 = AddSliderOption("Carry Weight Correction ", _s.SuH_SETcarrycorrect, "{0}") ; statusdisablehealthrec
			id33 = AddToggleOption("Disable Health Regen ", SETdisablehealthrecovery) ; statusdisablehealthrec
			id34 = AddToggleOption("Disable Magicka Regen ", SETdisablemagickarecovery) ;statusdisablemagickarec
			id35 = AddToggleOption("Disable Stamina Regen ", SETdisablestaminarecovery) ;statusdisablestaminarec
			
		;	Right Side
		SetCursorPosition(1)
			
			AddHeaderOption("Status ")
			id9 = AddTextOption("Lust Level ", arousalpercentage+"%" )
			id11 = AddTextOption("Lust State ", arousalstatetext)
			id30 = AddTextOption("HeartXP ", _s.SuH_PCSxp) ;status.xp
			AddEmptyOption()
			id31 = AddTextOption("HeartXP Gain ", _s.SuH_PCSxpgain+"%") ;status.xpgain
			id10 = AddTextOption("Character Gender ", playerGender) ; SuH_PCSgender
			id14 = AddTextOption("Character Level ", playerref.GetLevel()) ; playerlevel
			AddEmptyOption()
			AddHeaderOption("Hotkey Configuration")
			id8 = AddKeyMapOption("Drain Affects NPC Status - Toggle", _s.SuH_KEY_draintoggle) ; Set SuH_KEY_draintoggle
			id20 = AddKeyMapOption("Allow Drain to Kill - Toggle", _s.SuH_KEY_drainkilltoggle) ; Set SuH_KEY_drainkilltoggle
			id12 = AddKeyMapOption("View Current Lust State ", _s.SuH_KEY_arousalview) ; Set SuH_KEY_draintoggle
			id13 = AddKeyMapOption("Soul Pet Summon Menu ", _s.SuH_KEY_petself) ; Set SuH_spell_petself
			AddEmptyOption()
			id22 = AddTextOption("Framework Pref. ", fworkstring) ;status.framework
			id32 = AddTextOption("Succubus Heart Version "+modv, " ") ;status.version
		
	elseIf (page == "Heart Levels") ; Heart Levels
	
		if ftheart != 1
			debug.MessageBox("< Heart Levels > \n Use HeartXP to enhance your native Succubus Stats. Earn HeartXP through Succubus Heart activities such as draining enemies or satisfying your desires.")
			ftheart = 1
		endIf
		
		;	Variables
		int sexbonustime = Math.Ceiling( ((_s.SuH_PCSsexbonusmax * 1.0) / _s.SuH_PCSsexbonushour) * 60.0 )
		int fluidbonustime = Math.Ceiling( ((_s.SuH_PCSfluidbonusmax * 1.0) / _s.SuH_PCSfluidbonushour) * 60.0 )
		int effectivecap = (100 + ((6 + _s.SuH_PCScaplevel) * playerref.GetLevel()))
		
		SetCursorFillMode(TOP_TO_BOTTOM) ; id18 +
		
		;	Left Side
		SetCursorPosition(0)
		id0 = AddTextOption("HeartXP available", _s.SuH_PCSxp) ;heart.xp
		AddHeaderOption("Heart Levels")
		id1 = AddTextOption("+1 Health Cap", _s.SuH_PCScaphealth+" ["+_f.PC_getHeartXPcost("capHealth")+" XP]") ;heart.healthcap
		id2 = AddTextOption("+1 Magicka Cap", _s.SuH_PCScapmagicka+" ["+_f.PC_getHeartXPcost("capMagicka")+" XP]") ;heart.magickacap
		id3 = AddTextOption("+1 Stamina Cap", _s.SuH_PCScapstamina+" ["+_f.PC_getHeartXPcost("capStamina")+" XP]") ;heart.staminacap
		id6 = AddTextOption("+1 Effective Cap", (_s.SuH_PCScaplevel + 6)+" ("+effectivecap+") ["+_f.PC_getHeartXPcost("capEffect")+" XP]") ;heart.staminacap
		AddEmptyOption()
		id4 = AddTextOption("+10% Max Sex Bonus", sexbonustime+"min ["+_f.PC_getHeartXPcost("sexBonus")+" XP]") ;SuH_PCSsexbonusmax
		id5 = AddTextOption("+10% Max Fluid Bonus", fluidbonustime+"min ["+_f.PC_getHeartXPcost("fluidBonus")+" XP]") ;SuH_PCSfluidbonus
		AddEmptyOption()
		id7 = AddTextOption("HeartXP Gain", _s.SuH_PCSxpgain+"% ["+_f.PC_getHeartXPcost("xpGain")+" XP]") ;heart.xpgain
		;end/
		;ent/ Right Side
		SetCursorPosition(1)
		id17 = AddTextOption("BDSM Ratings ", "B:"+_s.SuH_PCSbpoint+" D:"+_s.SuH_PCSdpoint+" S:"+_s.SuH_PCSspoint+" M:"+_s.SuH_PCSmpoint)
		AddHeaderOption("Heart Levels")
		id8 = AddTextOption("+1 Health Absorption Rating", _s.SuH_PCSabsorbhealth+" ["+_f.PC_getHeartXPcost("absorbHealth")+" XP]") ;heart.absorbhealth
		id9 = AddTextOption("+1 Magicka Absorption Rating", _s.SuH_PCSabsorbmagicka+" ["+_f.PC_getHeartXPcost("absorbMagicka")+" XP]") ;heart.absorbmagicka
		id10 = AddTextOption("+1 Stamina Absorption Rating", _s.SuH_PCSabsorbstamina+" ["+_f.PC_getHeartXPcost("absorbStamina")+" XP]") ;heart.absorbstamina
		AddEmptyOption()
		id11 = AddTextOption("+1 Fluid Health Bonus", _s.SuH_PCSfluidhealth+" ["+_f.PC_getHeartXPcost("fluidHealth")+" XP]") ;heart.spermhealth
		id12 = AddTextOption("+1 Fluid Magicka Bonus", _s.SuH_PCSfluidmagicka+" ["+_f.PC_getHeartXPcost("fluidMagicka")+" XP]") ;heart.spermmagicka
		id13 = AddTextOption("+1 Fluid Stamina Bonus", _s.SuH_PCSfluidstamina+" ["+_f.PC_getHeartXPcost("fluidStamina")+" XP]") ;heart.spermstamina
		AddEmptyOption()
		AddEmptyOption()
		
	elseIf (page == "Skill Levels") ; Skill Levels
		if ftskill != 1
			debug.MessageBox("< Skill Levels > \n Spend SkillXP you've earned through Succubus Heart to level up vanilla skills. Earn SkillXP through Succubus Heart activities, such as draining beyond your Status Cap or letting your Status decay.")
			ftskill = 1
		endIf
		
		SetCursorFillMode(TOP_TO_BOTTOM) ; id1
		;	Left Side
		SetCursorPosition(0)
		id0 = AddTextOption("SkillXP", _s.SuH_PCSskillxp) ;skillsp
		AddEmptyOption()
		AddHeaderOption("Level Skills")
		id4 = AddTextOption("Alchemy ", Math.Floor(playerRef.GetBaseActorValue("alchemy"))+" ["+_f.PC_getSkillXPcost("alchemy")+" SkillXP]") ;skill.alchemy
		id5 = AddTextOption("Block ", Math.Floor(playerRef.GetBaseActorValue("block"))+" ["+_f.PC_getSkillXPcost("block")+" SkillXP]") ;skill.block
		id6 = AddTextOption("Destruction ", Math.Floor(playerRef.GetBaseActorValue("destruction"))+" ["+_f.PC_getSkillXPcost("destruction")+" SkillXP]") ;skill.destruction
		id7 = AddTextOption("Heavy Armor ", Math.Floor(playerRef.GetBaseActorValue("heavyarmor"))+" ["+_f.PC_getSkillXPcost("heavyarmor")+" SkillXP]") ;skill.heavyarmor
		id8 = AddTextOption("Light Armor ", Math.Floor(playerRef.GetBaseActorValue("lightarmor"))+" ["+_f.PC_getSkillXPcost("lightarmor")+" SkillXP]") ;skill.lightarmor
		id9 = AddTextOption("Marksman ", Math.Floor(playerRef.GetBaseActorValue("marksman"))+" ["+_f.PC_getSkillXPcost("marksman")+" SkillXP]") ;skill.marksman
		id10 = AddTextOption("Pickpocket ", Math.Floor(playerRef.GetBaseActorValue("pickpocket"))+" ["+_f.PC_getSkillXPcost("pickpocket")+" SkillXP]") ;skill.pickpocket
		id11 = AddTextOption("Smithing ", Math.Floor(playerRef.GetBaseActorValue("smithing"))+" ["+_f.PC_getSkillXPcost("smithing")+" SkillXP]") ;skill.smithing
		id12 = AddTextOption("Speechcraft ", Math.Floor(playerRef.GetBaseActorValue("speechcraft"))+" ["+_f.PC_getSkillXPcost("speechcraft")+" SkillXP]") ;skill.speechcraft
		
		;	Right Side
		SetCursorPosition(1)
		id2 = AddTextOption("XP available", _s.SuH_PCSxp) ;skill.xp
		id3 = AddSliderOption("XP to SPXP (10->1)",0,"{0}") ;skill.convert
		AddHeaderOption("Level Skills")
		id13 = AddTextOption("Alteration ", Math.Floor(playerRef.GetBaseActorValue("alteration"))+" ["+_f.PC_getSkillXPcost("alteration")+" SkillXP]") ;skill.alteration
		id14 = AddTextOption("Conjuration ", Math.Floor(playerRef.GetBaseActorValue("conjuration"))+" ["+_f.PC_getSkillXPcost("conjuration")+" SkillXP]") ;skill.conjuration
		id15 = AddTextOption("Enchanting ", Math.Floor(playerRef.GetBaseActorValue("enchanting"))+" ["+_f.PC_getSkillXPcost("enchanting")+" SkillXP]") ;skill.enchanting
		id16 = AddTextOption("Illusion ", Math.Floor(playerRef.GetBaseActorValue("illusion"))+" ["+_f.PC_getSkillXPcost("illusion")+" SkillXP]") ;skill.illusion
		id17 = AddTextOption("Lockpicking ", Math.Floor(playerRef.GetBaseActorValue("lockpicking"))+" ["+_f.PC_getSkillXPcost("lockpicking")+" SkillXP]") ;skill.lockpicking
		id18 = AddTextOption("One-Handed ", Math.Floor(playerRef.GetBaseActorValue("onehanded"))+" ["+_f.PC_getSkillXPcost("onehanded")+" SkillXP]") ;skill.onehanded
		id19 = AddTextOption("Restoration ", Math.Floor(playerRef.GetBaseActorValue("restoration"))+" ["+_f.PC_getSkillXPcost("restoration")+" SkillXP]") ;skill.restoration
		id20 = AddTextOption("Sneak ", Math.Floor(playerRef.GetBaseActorValue("sneak"))+" ["+_f.PC_getSkillXPcost("sneak")+" SkillXP]") ;skill.sneak
		id21 = AddTextOption("Two-Handed ", Math.Floor(playerRef.GetBaseActorValue("twohanded"))+" ["+_f.PC_getSkillXPcost("twohanded")+" SkillXP]") ;skill.twohanded
		
	elseIf (page == "Passives") ; Passives
		if ftpassives != 1
			debug.MessageBox("< Passives > \n Spend/Decrease Status Caps to unlock or strengthen your Passive Succubus Abilities. Passive Abilities gain additional bonuses based on your BDSM Rating. BDSM Rating is improved when increasing Heart Levels.")
			ftpassives = 1
		endIf
		
		;ent/ Variables
		int capexcelrankall = _s.SuH_rank_capexcel + _s.SuH_rank_capexcel2
		int perfectorgasmrankall = _s.SuH_rank_perfectorgasm + _s.SuH_rank_perfectorgasm2
		int lusciousliquidsrankall = _s.SuH_rank_lusciousliquids + _s.SuH_rank_lusciousliquids2
		int masochistrankall = _s.SuH_rank_masochist + _s.SuH_rank_masochist2 + _s.SuH_rank_masochist3
		int savingessencerankall = _s.SuH_rank_savingessence + _s.SuH_rank_savingessence2
		int deviouspartnerrankall = _s.SuH_rank_deviouspartner + _s.SuH_rank_deviouspartner2
		int violencerankall = _s.SuH_rank_violence + _s.SuH_rank_violence2 + _s.SuH_rank_violence3
		int seducerankall = _s.SuH_rank_seducer + _s.SuH_rank_seducer2
		int passiveresetcost = passiveresetcostcalc()
		
		string selfstackerplus = "Locked"
		if _s.SuH_rank_selfstackerplus > 0
			selfstackerplus = "Unlocked"
		endIf
		string giftedconsentplus = "Locked"
		if _s.SuH_rank_giftedconsentplus > 0
			giftedconsentplus = "Unlocked"
		endIf
		string capexcelplus = "Locked"
		if _s.SuH_rank_capexcelplus > 0
			capexcelplus = "Unlocked"
		endIf
		string soultapplus = "Locked"
		if _s.SuH_rank_soultapplus > 0
			soultapplus = "Unlocked"
		endIf
		
		SetCursorFillMode(TOP_TO_BOTTOM); id46+
		
		;	Left Side
		SetCursorPosition(0)
			id0 = AddTextOption("Status ", "H:"+_s.SuH_PCScaphealth+"  M:"+_s.SuH_PCScapmagicka+"  S:"+_s.SuH_PCScapstamina)
			id1 = AddTextOption("BDSM Ratings ", "B:"+_s.SuH_PCSbpoint+" D:"+_s.SuH_PCSdpoint+" S:"+_s.SuH_PCSspoint+" M:"+_s.SuH_PCSmpoint) ;spell.bdsmtrue
			; Combat Passives
			AddHeaderOption("Combat Passives")
			id4 = AddTextOption("Masochist", "rank "+masochistrankall) ;spell.masochist
			id5 = AddTextOption("   + Lust Gained", _s.SuH_rank_masochist) ;spell.masochistrank
			id6 = AddTextOption("   + Stamina Recovery", _s.SuH_rank_masochist2) ;spell.masochistrank2
			id30 = AddTextOption("   + HeartXP Earned", _s.SuH_rank_masochist3) ;SuH_rank_masochist3
			id7 = AddTextOption("Violence", "rank "+violencerankall) ;spell.violence
			id8 = AddTextOption("   + Health Absorbtion", _s.SuH_rank_violence) ;spell.violencerank
			id9 = AddTextOption("   + Magicka Absorption", _s.SuH_rank_violence2) ;spell.violencerank2
			id10 = AddTextOption("   + Stamina Absorption", _s.SuH_rank_violence3) ;spell.violencerank3
			id11 = AddTextOption("Regal Glow", "rank "+_s.SuH_rank_regalglow) ;spell.regalglow
			id12 = AddTextOption("   + Armor Rating", _s.SuH_rank_regalglow) ;spell.regalglowrank
			id13 = AddTextOption("Saving Essence", "rank "+savingessencerankall) ;spell.savingessence
			id14 = AddTextOption("   + Health Recovery", _s.SuH_rank_savingessence) ;spell.savingessencerank
			id15 = AddTextOption("   - Fluid Bonus Cost", _s.SuH_rank_savingessence2) ;spell.savingessencerank2
			AddHeaderOption("Sex Passives")
			id16 = AddTextOption("Seducer ", "rank "+_s.SuH_rank_seducer) ;spell.seducer
			id17 = AddTextOption("   + Success Rate ", _s.SuH_rank_seducer) ;spell.seducerrank
			id28 = AddTextOption("   + Lust Resistance ", _s.SuH_rank_seducer2) ;spell.seducerrank
			id18 = AddTextOption("Devious Partner ", "rank "+deviouspartnerrankall) ;spell.deviouspartner
			id19 = AddTextOption("   + Steal Gold Chance ", _s.SuH_rank_deviouspartner) ;spell.deviouspartnerrank
			id20 = AddTextOption("   + Steal Item Chance ", _s.SuH_rank_deviouspartner2) ;spell.deviouspartnerrank2
			id21 = AddTextOption("Gifted Consent", "rank "+_s.SuH_rank_giftedconsent) ;spell.giftedconsent
			id22 = AddTextOption("   + Max Status Increase", _s.SuH_rank_giftedconsent) ;spell.giftedconsentrank
			id31 = AddTextOption("   = Gifted Consent+", giftedconsentplus) ;spell.giftedconsentrank
		
		;	Right Side
		SetCursorPosition(1)
			id2 = AddTextOption("Increase Rating", _f.PC_getHeartXPcost("BDSMrank")+" XP") ;spell.xp
			id3 = AddTextOption(">>> Reset Passives/Actives ", passiveresetcost+" XP") ;spell.reset
			; Supportive Passives
			AddHeaderOption("Supportive Passives")
			id23 = AddTextOption("Luscious Liquids ", "rank "+lusciousliquidsrankall) ;spell.lusciousliquids
			id24 = AddTextOption("   + Status Recovery ", _s.SuH_rank_lusciousliquids) ;spell.lusciousliquidsrank
			id25 = AddTextOption("   + Fluid Bonus Gain ", _s.SuH_rank_lusciousliquids2) ;spell.lusciousliquidsrank2
			id40 = AddTextOption("Cap Excel ", "rank "+capexcelrankall) ;spell.capexcel
			id41 = AddTextOption("   + Potential Cap ", _s.SuH_rank_capexcel) ;spell.capexcelrank
			id42 = AddTextOption("   + Decay Delay ", _s.SuH_rank_capexcel2) ;spell.capexcelrank2
			id29 = AddTextOption("   = Cap Excel+ ", capexcelplus) ;spell.capexcelrank2
			id26 = AddTextOption("Formal Beauty", "rank "+_s.SuH_rank_formalbeauty) ;spell.formalbeauty
			id27 = AddTextOption("   + Status Recovery", _s.SuH_rank_formalbeauty) ;spell.formalbeautyrank
			id33 = AddTextOption("Self Indulgent", "rank "+_s.SuH_rank_selfstacker) ;spell.selfstacker
			id34 = AddTextOption("   + Sex Bonus Gain", _s.SuH_rank_selfstacker) ;spell.selfstackerrank
			id43 = AddTextOption("   = Self Indulgent+", selfstackerplus) ;spell.selfstackerrank
			AddEmptyOption()
			AddHeaderOption("Sex Passives")
			id35 = AddTextOption("Healthy Absorber ", "rank "+_s.SuH_rank_healthyabsorber) ;spell.healthyabsorber
			id36 = AddTextOption("   + Healing/Recovery", _s.SuH_rank_healthyabsorber) ;spell.healthyabsorberrank
			id32 = AddTextOption("Soul Siphon ", "rank "+_s.SuH_rank_soultap) ;SuH_rank_soultap
			id44 = AddTextOption("   + Soul Trap Chance ", _s.SuH_rank_soultap) ;SuH_rank_soultap
			id45 = AddTextOption("   = Soul Siphon+ ", soultapplus) ;SuH_rank_soultapplus
			id37 = AddTextOption("Perfect Orgasm", "rank "+perfectorgasmrankall) ;spell.perfectorgasm
			id38 = AddTextOption("   + Rare Drop Chance", _s.SuH_rank_perfectorgasm) ;spell.perfectorgasmrank
			id39 = AddTextOption("   + Death Drop Chance", _s.SuH_rank_perfectorgasm2) ;spell.perfectorgasmrank2
			AddEmptyOption()
			
	elseIf (page == "Actives") ; Actives
		if ftactives != 1
			debug.MessageBox("< Actives > \n Spend/Decrease Status Caps to unlock or strengthen your Active Succubus Abilities. Active Abilities gain additional bonuses based on your BDSM Rating. BDSM Rating is improved when increasing Heart Levels.")
			ftactives = 1
		endIf
		
		string sexualenticestring = "Tier 1"
		if _s.SuH_rank_sexualentice == 2
			sexualenticestring = "Tier 2"
		elseif _s.SuH_rank_sexualentice > 2
			sexualenticestring = "[Tier 3]"
		endIf
		
		string sexualenragestring = "Tier 1"
		if _s.SuH_rank_sexualenrage == 2
			sexualenragestring = "Tier 2"
		elseif _s.SuH_rank_sexualenrage > 2
			sexualenragestring = "[Tier 3]"
		endIf
		int passiveresetcost = passiveresetcostcalc()
		
		SetCursorFillMode(TOP_TO_BOTTOM) ; id7
		
		;	Left Side
		SetCursorPosition(0)
			id0 = AddTextOption("Status ", "H:"+_s.SuH_PCScaphealth+"  M:"+_s.SuH_PCScapmagicka+"  S:"+_s.SuH_PCScapstamina)
			AddHeaderOption("Seduction Spells")
			id1 = AddTextOption("Sexual Entice", sexualenticestring)
			id4 = AddTextOption("   = Improve", " ")
			id2 = AddTextOption("Sexual Enrage", sexualenragestring)
			id5 = AddTextOption("   = Improve", " ")
			id3 = AddTextOption("Sexual Embrace", "[Tier 1]")
			
		;	Right Side
		SetCursorPosition(1)
			id6 = AddTextOption(">>> Reset Passives/Actives ", passiveresetcost+" XP") ;spell.reset
	
	elseIf (page == "Soul Pets") ; Pets
		if ftsoul != 1
			debug.MessageBox("< Soul Pets > \n MCM for managing your Soul Pets. When souls have been replicated they'll show up here, select their slot for various options. Soul Pets will level up and strengthen through gameplay.")
			ftsoul = 1
		endIf
		;	Variables
		if _s.SuH_petactorbases[petselectedslot] == none ; if selected slot is invalid
			petselectedslot = 0 ; Pet Slot currently selected, default to first slot
		endIf
		
		petslotarray = new int[25] ; Array for Pet Slot entries
		petselectarray = new bool[25] ; Selection array for which pet slot is selected
		petselectarray[petselectedslot] = true ; Show enabled pet
		petmenuoption = 0 ; Action selected, such as "Swap Slot"
		petdeletewarning = 0 ; number of warnings before deleting a pet
		string petActiveStatus = "Returned" ; Active Pet Status, default to returned
		if _s.SuH_petactoralive[petselectedslot].IsDisabled() == false ; check if enabled, which should mean actively in game world
			if _s.SuH_Frame_Sexlab > 0 && _s.SexLab.ValidateActor(_s.SuH_petactoralive[petselectedslot]) == -10
				petActiveStatus = "In-Act" ; set text to In-Act
			else
				petActiveStatus = "Summoned" ; set text to summoned
			endIf
		endIf
		
		string activePetName = " "
		if _s.SuH_petactive >= 0
			activePetName = _s.SuH_petnames[_s.SuH_petactive]
		endIf
		
		string petTrait0 = " - - - "
		if _s.SuH_pettrait0[petselectedslot] > 0
			petTrait0 = _f.PetGetTraitName(_s.SuH_pettrait0[petselectedslot])
		endIf
		string petTrait1 = " - - - "
		if _s.SuH_pettrait1[petselectedslot] > 0
			petTrait1 = _f.PetGetTraitName(_s.SuH_pettrait1[petselectedslot])
		endIf
		string petTrait2 = " - - - "
		if _s.SuH_pettrait2[petselectedslot] > 0
			petTrait2 = _f.PetGetTraitName(_s.SuH_pettrait2[petselectedslot])
		endIf
		
		SetCursorFillMode(TOP_TO_BOTTOM) ; id16 +
		
		;	Left Side
		SetCursorPosition(0)
			id0 = AddTextOption("Soul Pet Skill Level ", _s.SuH_petskill) ;pet.skill
			id3 = AddTextOption(" ", " ") ; Display current action "tooltip" such as "Select slot to swap with "
			AddHeaderOption("Pet Souls")
			
			int i = 0 ; Create neccessary Soul Pet entries, has a max of 25 entries
			while i < _s.SuH_petactorbases.Length
				if _s.SuH_petactorbases[i] != none
					petslotarray[i] = AddToggleOption((_s.SuH_petnames[i])+" (level "+_s.SuH_petlevels[i]+")", petselectarray[i])
				endIf
				i += 1
			endWhile
			
		;	Right Side
		SetCursorPosition(1)
			id1 = AddTextOption("Active Pet ", activePetName) ;pet.activepet
			id2 = AddTextOption("Selected Pet ", _s.SuH_petnames[petselectedslot]) ;pet.activepet
			AddHeaderOption("Pet Options")
			id6 = AddTextOption("Dismiss Active Pet ", " ")
			id5 = AddTextOption("Summon Selected Pet ", " ")
			id7 = AddTextOption("Unsummon Selected Pet ", " ")
			id8 = AddInputOption("Rename Selected Pet ", " ")
			id9 = AddTextOption("Swap Pet Slot ", " ")
			AddHeaderOption("Pet Status")
			id10 = AddTextOption("Pet Active Status ", petActiveStatus)
			id11 = AddTextOption("Pet Traits ", " - - - ")
			id12 = AddTextOption(" ", petTrait0)
			id13 = AddTextOption(" ", petTrait1)
			id14 = AddTextOption(" ", petTrait2)
			id15 = AddMenuOption("Remove Pet Trait", "[30 Blood Chips]")
			id4 = AddTextOption("Remove Pet ", " ")

	elseIf (page == "Titles") ; Titles [Needs a full re-rwite when Perks are changed into Titles]
	
		if fttitle != 1
			debug.MessageBox("< Titles > \n Earn Reputaion through various activities for bonus HeartXP.")
			fttitle = 1
		endIf
		
		;	Variables
		
		SetCursorFillMode(TOP_TO_BOTTOM) ; id11
		;	Left Side
		SetCursorPosition(0)
		AddHeaderOption("Evolving Titles")
		id0 = AddTextOption(_f.PCE_gettitlename("Succubus")+" (Rank "+_s.SuH_title_succubus+")", " ")
		id1 = AddTextOption(_f.PCE_gettitlename("Drinker")+" (Rank "+_s.SuH_title_drinker+")", " ")
		id2 = AddTextOption(_f.PCE_gettitlename("Friendly")+" (Rank "+_s.SuH_title_friendly+")", " ")
		id4 = AddTextOption(_f.PCE_gettitlename("Pettrain")+" (Rank "+_s.SuH_title_pettrain+")", " ")
		id8 = AddTextOption(_f.PCE_gettitlename("OfferItem")+" (Rank "+_s.SuH_title_offeritem+")", " ")
		id9 = AddTextOption(_f.PCE_gettitlename("Seduced")+" (Rank "+_s.SuH_title_seducer+")", " ")
		
		;	Right Side
		SetCursorPosition(1)
		AddHeaderOption("Secret Titles")
		id6 = AddTextOption(_f.PCE_gettitlename("Drainkilled"), " ")
		id5 = AddTextOption(_f.PCE_gettitlename("Realmvisit"), " ")
		id10 = AddTextOption(_f.PCE_gettitlename("Statdown"), " ")
		id3 = AddTextOption(_f.PCE_gettitlename("Pethit"), " ")
		id7 = AddTextOption(_f.PCE_gettitlename("Fedchest"), " ")
		
	elseif (page == "Settings") ; Settings
	
		; first time message
		if ftsettings != 1
			debug.MessageBox("< Settings > \n  Enable and Customize various aspects of Succubus Heart. Very important for a first time set-up!")
			ftsettings = 1
		endIf
		
		; Variables
		int SETnpc2npchealth = Math.Floor(_s.SuH_SETnpc2npchealth*100)
		int SETnpc2npchealthmin = Math.Floor(_s.SuH_SETnpc2npchealthmin)
		int SETnpc2pchealth = Math.Floor(_s.SuH_SETnpc2pchealth*100)
		int SETnpc2pchealthmin = Math.Floor(_s.SuH_SETnpc2pchealthmin)
		int SETpc2npchealth = Math.Floor(_s.SuH_SETpc2npchealth*100)
		int SETpc2npchealthmin = Math.Floor(_s.SuH_SETpc2npchealthmin)
		int SETpc2npcstamina = Math.Floor(_s.SuH_SETpc2npcstamina*100)
		int effectmulti = Math.Floor(100 * _s.SuH_PCSeffectmulti)
		int SETrevivecost = Math.Floor(_s.SuH_SETrevivecost*100)
		int arousalgenspeed = Math.Floor(_s.SuH_PCSarousalgainmulti * 100)
		
		int SETpetspells = 0
		if playerref.HasSpell(_s.SuH_spell_petself)
			SETpetspells = 1
		else
			SETpetspells = 0
		endIF
		
		bool hostilevigil = false
		if playerref.IsInFaction(_s.SuH_Vigilhostile)
			hostilevigil = true
		endIf
		
		string forcedrespawndisplay = "Disabled"
		if _s.SuH_SETrandomdeathspawn == 1
			forcedrespawndisplay = "Random Location"
		elseif _s.SuH_SETrandomdeathspawn == 2
			forcedrespawndisplay = "Last Entrance"
		endIf
		
		string drainaffectnpc = "No NPCs"
		if _s.SuH_SETnpcabsorb == 1
			drainaffectnpc = "All NPCs"
		elseif _s.SuH_SETnpcabsorb == 2
			drainaffectnpc = "Non-Allies"
		elseif _s.SuH_SETnpcabsorb == 3
			drainaffectnpc = "Hostile Only"
		endIf
		
		string drainkillallow = "Never"
		if _s.SuH_SETallowdrainkill == 1
			drainkillallow = "Always"
		elseif _s.SuH_SETallowdrainkill == 2
			drainkillallow = "Non-Allies"
		elseif _s.SuH_SETallowdrainkill == 3
			drainkillallow = "Hostile Only"
		endIf
		
		SetCursorFillMode(TOP_TO_BOTTOM) ; id47 +
		
		;	Left Side
		SetCursorPosition(0)
			
			AddHeaderOption("General Options") ; General Options
			id40 = AddToggleOption("Use SPID for Dynamic Scripts ", _s.SuH_SETdynaspid) ;status.SuH_SETdynaspid
			id46 = AddToggleOption("Only Use Framework Pref. ", _s.SuH_SETonlyframepref) ;status.SuH_SETonlyframepref
			id8 = AddToggleOption("Allow Death Drops ", _s.SuH_SETdeathdrops) ;status.deathdrops
			id39 = AddToggleOption("Females Give Milk ", _s.SuH_SETmilkdistribute) ;status.milkdistribute
			id41 = AddToggleOption("Males Give Sperm ", _s.SuH_SETspermdistribute) ;status.SuH_SETspermdistribute
			id7 = AddToggleOption("Calm Enemies During Sex", _s.SuH_SETcalmaura) ;calmaura
			id44 = AddToggleOption("Prevent Deaths During Sex", _s.SuH_SETpreventactdeath) ;SuH_SETpreventactdeath
			id43 = AddToggleOption("Attempt SexLab AI Bug Fix", _s.SuH_SETslaifix) ;SuH_SETslaifix
			id12 = AddToggleOption("Hostile Vigil. of Stendarr ", hostilevigil) ;hostilevigilfaction
			id45 = AddToggleOption("Realm Spells Cost Magicka ", _s.SuH_SETrealmspellcost) ;SuH_SETrealmspellcost
			AddEmptyOption()
			
			AddHeaderOption("Lust Options") ; Arousal Options
			id10 = AddSliderOption("Lust Gain Multiplier ", arousalgenspeed, "{0}%") ;status.desiregain
			id18 = AddToggleOption("Lust Defects ", _s.SuH_SETarousaldefect)
				;	Add Arousal Debuff Setting
			AddEmptyOption()
			
			AddHeaderOption("Sexual Drain Options") ; Sexual Drain Options
			id0 = AddSliderOption("HeartXP Multiplier ",effectmulti, "{0}%") ;effectmulti
			id1 = AddMenuOption("Drain Affects NPC Status ", drainaffectnpc) ;setnpcabsorb
			id2 = AddToggleOption("Always Get Drain Benfits ", _s.SuH_SETalwaysabsorbbenefit) ;setnpcabsorb
			id4 = AddMenuOption("Allow Drain to Kill ", drainkillallow) ;drainkill
			id5 = AddToggleOption("Drain Always Kills ", _s.SuH_SETalwaysdrainkill) ;status.alwaysdrainkill
			id42 = AddToggleOption("Drain Visuals During Act ", _s.SuH_SETdrainvisualinact) ;status.alwaysdrainkill
			id6 = AddToggleOption("Drain Resets on Orgasm ", _s.SuH_SETdrainresetorgasm) ;SuH_SETdrainresetorgasm
			AddEmptyOption()
			
			AddHeaderOption("Animation Options") ; Animation Options
			id15 = AddToggleOption("Allow Male Homosexuals", _s.SuH_SETallowmalehomo) ;status.malehomo
			id16 = AddToggleOption("Allow Female Homosexuals", _s.SuH_SETallowfemalehomo) ;status.femalehomo
			id17 = AddToggleOption("Force Cowgirl for F.Aggressor ", _s.SuH_SETrestrictact) ;status.restricact
			id13 = AddToggleOption("End Sex When Attacked", _s.SuH_SETactendonatk) ;status.endactonatk
			id14 = AddToggleOption("Clean Arrows off Player", _s.SuH_SETclearactor) ;status.clearactor
			
		;	Right Side
		SetCursorPosition(1)
		
			AddHeaderOption("Soul Pet Options") ; Soul Pet Options
			id19 = AddToggleOption("Display Base Soul Pet Spells", SETpetspells) ;status.petspells
			id20 = AddToggleOption("Remove Soul Pets On Death ", _s.SuH_SETpetremoveondeath) ;status.removepet
			id3 = AddToggleOption("Dismiss When Summoning Pet ", _s.SuH_SETpetnewsumdismiss) ;status.dismisspet
			id9 = AddToggleOption("Don't Unfollow ", _s.SuH_SETpetstayfollowing) ;status.petstayfollowing
			id11 = AddToggleOption("Act Traits won't kill ", _s.SuH_SETtraitwontkill) ;_s.SuH_SETtraitwontkill
			
			AddEmptyOption()
			
			AddHeaderOption("Combat Seduction Options") ; Combat Seduction Options
			id21 = AddToggleOption("Enable Combat Seduction", _s.SuH_SETcombatseduction) ;status.combatseduction
			id22 = AddSliderOption("Submit Cooldown", _s.SuH_SETcscooldown, "{0} Seconds") ;status.cscooldown
			id23 = AddSliderOption("Player Submits while under...", SETpc2npchealth, "{0}% Health") ;status.pctonpchealth
			id24 = AddSliderOption("Player Submits while under...", SETpc2npchealthmin, "{0} Health") ;status.pctonpchealthmin
			id25 = AddSliderOption("Player submits while under...", SETpc2npcstamina, "{0}% Stamina") ;status.pctonpcstamina
			id26 = AddSliderOption("NPC Submits to PC while under...", SETnpc2pchealth, "{0}% Health") ;status.npctopchealth
			id27 = AddSliderOption("NPC Submits to PC while under...", SETnpc2pchealthmin, "{0} Health") ;status.npctolchealthmin
			id28 = AddSliderOption("NPC Submits to NPC while under...", SETnpc2npchealth, "{0}% Health") ;status.npctonpchealth
			id29 = AddSliderOption("NPC Submits to NPC while under...", SETnpc2npchealthmin, "{0} Health") ;status.npctonpchealthmin
			AddEmptyOption()
			
			AddHeaderOption("Death Override Mode Options") ; DOM Options
			id30 = AddToggleOption("Enabled Death Override Mode", _s.SuH_SETspecialdeath) ;status.dom
			id31 = AddMenuOption("Forced Respawn Location", forcedrespawndisplay) ;status.randomdeathspawm
			id32 = AddToggleOption("Lose Items on Death", _s.SuH_SETsdloseitems) ;status.loseitems
			id33 = AddToggleOption("Lose Gold on Death", _s.SuH_SETsdlosegold) ;status.losegold
			id34 = AddToggleOption("Lose Blood Chips on Death", _s.SuH_SETsdlosebloodchips) ;status.losebloodchips
			id35 = AddToggleOption("Destroy Equipped Items on Death", _s.SuH_SETsdloseequip) ;status.loseequip
			id36 = AddSliderOption("Revival Cost", SETrevivecost, "{0}% Max Status") ;status.SETrevivecost
			id37 = AddSliderOption("Bleed Out Delay", _s.SuH_SETcsbleedoutdelay, "{0} Sec") ;status.csbleedoutdelay
			id38 = AddToggleOption("Never Die Mode", _s.SuH_SETneverdiemode) ;neverdie
			AddEmptyOption()
			AddEmptyOption()
			AddEmptyOption()
			
	elseIf (page == "Help") ; Help
	
		if fthelp != 1
			debug.MessageBox("< Help > \n  This MCM menu stores general information and help articles. If you're having issues understanding mechanics or want to check what various terms refer to, check here! If you don't find help here you can still join the Discord channel for further assistance!")
			fthelp = 1
		endIf
		
		SetCursorFillMode(TOP_TO_BOTTOM) ;36+?
		
		;	Left Side
		SetCursorPosition(0)
			id33 = AddTextOption("TBC Discord for Updates and Support","> > >")
			AddHeaderOption("Key Terms / Vocabulary")
			id13 = AddTextOption("Status", " ") ; Status
			id14 = AddTextOption("Max Status", " ") ; MaxStatus
			id15 = AddTextOption("Status Cap", " ") ; StatusCap
			id16 = AddTextOption("HeartXP", " ") ; HeartXP
			id17 = AddTextOption("SkillXP", " ") ; SkillXP
			id18 = AddTextOption("Sex Bonus (Time)", " ") ; SexBonusTime
			id19 = AddTextOption("Fluid Bonus (Time)", " ") ; FluidBonusTime
			id20 = AddTextOption("Sex Act", " ") ; SexAct
			AddHeaderOption("Menu Descriptions")
			id21 = AddTextOption("Status", " ") ; Status
			id22 = AddTextOption("Heart Levels", " ") ; Heart Levels
			id23 = AddTextOption("Skill Levels", " ") ; Skill Levels
			id24 = AddTextOption("Passives", " ") ; Passives
			id25 = AddTextOption("Actives", " ") ; Actives
			id26 = AddTextOption("Soul Pets", " ") ; Soul Pets
			id28 = AddTextOption("Titles", " ") ; Titles
			id29 = AddTextOption("Help", " ") ; Help
			
		;	Right Side
		SetCursorPosition(1)
			id32 = AddTextOption("https://discord.gg/h3vB7S4FEw", "") ; https://discord.gg/h3vB7S4FEw
			AddHeaderOption("The Basics")
			id0 = AddTextOption("Drain and it's Effects", " ") ;help.drain
			id11 = AddTextOption("Lust and Withdrawl", " ") ;help.arousal
			id3 = AddTextOption("Earning and Spending HeartXP", " ") ;help.xp
			id4 = AddTextOption("Earning and Spending SkillXP", " ") ;help.sp
			id1 = AddTextOption("Sex/Death Drops", " ") ;help.drops
			id5 = AddTextOption("BDSM Rating and Abilities", " ") ;help.bdsm
			id6 = AddTextOption("Unlocking Titles", " ") ;help.titles
			AddHeaderOption("Optional Mechanics")
			id2 = AddTextOption("The Succubus Realm", " ") ;help.realm
			id27 = AddTextOption("Offering System ", " ") ;offeringsystem
			id34 = AddTextOption("Fluid Fountain ", " ") ;fluidfountain
			id35 = AddTextOption("Tali's Worktable ", " ") ;talitable
			id7 = AddTextOption("Soul Pets", " ") ;help.pets
			id9 = AddTextOption("Combat Seduction", " ") ;help.cs
			id10 = AddTextOption("Death Override Mode", " ") ;help.dom
			AddHeaderOption("Random Notes")
			id12 = AddTextOption("Woops...", " ") ;help.hungrychest
			id30 = AddTextOption("He's always there for me <3", " ") ;help.petuse
			id8 = AddTextOption("Sweet dreams are sweeter with me ", " ") ;help.seduction
			id31 = AddTextOption("I had too many to use ", " ") ;help.offering
	endIf
endEvent
Event OnOptionSelect(int option)
	
	if(CurrentPage == "Initiate") ; Initiate
		if(option == id0) ; Initiate
			SetTextOptionValue(id0, "Starting : Please Exit MCM ") ; Initiate
			_s.InitProperties(true)
			_s.SuH_MCMversion = 5
			MCMupdate()
		endIf
		
	elseif(CurrentPage == "Status") ; Status
		if(option == id22) ;framework
			if _s.SuH_framework == 1 ; If set to SexLab
				If _s.SuH_Frame_OStim > 0
					_s.SuH_framework = 2
					_s.SuH_Frame_OStim = 2
					if _s.SuH_SETonlyframepref > 0
						if _s.SuH_Frame_SexLab  > 1
							_s.SuH_Frame_SexLab = 1
						endIf
					endIf
					SetTextOptionValue(id22, "OStim")
				elseif _s.SuH_Frame_Sexlab == 0
					_s.SuH_framework = 0
					SetTextOptionValue(id22, "")
				endIf
			elseif _s.SuH_framework == 2 ; If set to OStim
				if _s.SuH_Frame_Sexlab > 0
					_s.SuH_framework = 1
					_s.SuH_Frame_SexLab = 2
					if _s.SuH_SETonlyframepref > 0
						if _s.SuH_Frame_OStim  > 1
							_s.SuH_Frame_OStim = 1
						endIf
					endIf
					SetTextOptionValue(id22, "SexLab")
				elseif _s.SuH_Frame_OStim == 0
					_s.SuH_framework = 0
					SetTextOptionValue(id22, "")
				endIf
			else ; If no preference set
				if _s.SuH_Frame_Sexlab > 0
					_s.SuH_framework = 1
					SetTextOptionValue(id22, "SexLab")
				elseif _s.SuH_Frame_OStim > 0
					_s.SuH_framework = 2
					SetTextOptionValue(id22, "OStim")
				endIf
			endIf
		elseif(option == id33) ;statusdisablehealthrec
			if _s.SuH_SETdisablehealthrecovery == 0
				_s.SuH_SETdisablehealthrecovery = playerref.GetBaseActorValue("HealRate")
				playerref.SetActorValue("HealRate", 0.0)
				SetToggleOptionValue(id33, True) ;statusdisablehealthrec
			else
				playerref.SetActorValue("HealRate", _s.SuH_SETdisablehealthrecovery)
				_s.SuH_SETdisablehealthrecovery = 0
				SetToggleOptionValue(id33, False) ;statusdisablehealthrec
			endIf
		elseif(option == id34) ;statusdisablemagickarec
			if _s.SuH_SETdisablemagickarecovery == 0
				_s.SuH_SETdisablemagickarecovery = playerref.GetBaseActorValue("MagickaRate")
				playerref.SetActorValue("MagickaRate", 0.0)
				SetToggleOptionValue(id34, true) ;statusdisablemagickarec
			else
				playerref.SetActorValue("MagickaRate", _s.SuH_SETdisablemagickarecovery)
				_s.SuH_SETdisablemagickarecovery = 0
				SetToggleOptionValue(id34, false) ;statusdisablemagickarec
			endIf
		elseif(option == id35) ;statusdisablestaminarec
			if _s.SuH_SETdisablestaminarecovery == 0
				_s.SuH_SETdisablestaminarecovery = playerref.GetBaseActorValue("StaminaRate")
				playerref.SetActorValue("StaminaRate", 0.0)
				SetToggleOptionValue(id35, true) ;statusdisablestaminarec
			else
				playerref.SetActorValue("StaminaRate", _s.SuH_SETdisablestaminarecovery)
				_s.SuH_SETdisablestaminarecovery = 0
				SetToggleOptionValue(id35, false) ;statusdisablestaminarec
			endIf
		endIf
	;end/
	;	Heart Levels
	elseIf(CurrentPage == "Heart Levels")
		if(option == id1) ;heart.healthcap
			int caphealthcost = _f.PC_getHeartXPcost("capHealth")
			if _s.SuH_PCSxp >= caphealthcost
				_s.SuH_PCSxp -= caphealthcost
				_s.SuH_PCScaphealth += 1
				SetTextOptionValue(id1, _s.SuH_PCScaphealth+" ["+_f.PC_getHeartXPcost("capHealth")+" XP]") ;heart.healthcap
			endIf
		elseif(option == id2) ;heart.magickacap
			int capmagickacost = _f.PC_getHeartXPcost("capMagicka")
			if _s.SuH_PCSxp >= capmagickacost
				_s.SuH_PCSxp -= capmagickacost
				_s.SuH_PCScapmagicka += 1
				SetTextOptionValue(id2, _s.SuH_PCScapmagicka+" ["+_f.PC_getHeartXPcost("capMagicka")+" XP]") ;heart.magickacap
			endIf
		elseif(option == id3) ;heart.staminacap
			int capstaminacost = _f.PC_getHeartXPcost("capStamina")
			if _s.SuH_PCSxp >= capstaminacost
				_s.SuH_PCSxp -= capstaminacost
				_s.SuH_PCScapstamina += 1
				SetTextOptionValue(id3, _s.SuH_PCScapstamina+" ["+_f.PC_getHeartXPcost("capStamina")+" XP]") ;heart.staminacap
			endIf
		elseif(option == id6) ;SuH_PCScaplevel
			int xpcost = _f.PC_getHeartXPcost("capEffect")
			if _s.SuH_PCSxp >= xpcost
				_s.SuH_PCSxp -= xpcost
				_s.SuH_PCScaplevel += 1
				SetTextOptionValue(id6, (_s.SuH_PCScaplevel + 6)+" ("+(100 + ((6 + _s.SuH_PCScaplevel) * playerref.GetLevel()))+") ["+_f.PC_getHeartXPcost("capEffect")+" XP]") ;heart.staminacap
			endIf
		elseif(option == id8) ;heart.absorbhealth
			int absorbhealthcost = _f.PC_getHeartXPcost("absorbHealth")
			if _s.SuH_PCSxp >= absorbhealthcost
				_s.SuH_PCSxp -= absorbhealthcost
				_s.SuH_PCSabsorbhealth += 1
				SetTextOptionValue(id8, _s.SuH_PCSabsorbhealth+" ["+_f.PC_getHeartXPcost("absorbHealth")+" XP]") ;heart.absorbhealth
			endIf
		elseif(option == id9) ;heart.absorbmagicka
			int absorbmagickacost = _f.PC_getHeartXPcost("absorbMagicka")
			if _s.SuH_PCSxp >= absorbmagickacost
				_s.SuH_PCSxp -= absorbmagickacost
				_s.SuH_PCSabsorbmagicka += 1
				SetTextOptionValue(id9, _s.SuH_PCSabsorbmagicka+" ["+_f.PC_getHeartXPcost("absorbMagicka")+" XP]") ;heart.absorbmagicka
			endIf
		elseif(option == id10) ;heart.absorbstamina
			int absorbstaminacost = _f.PC_getHeartXPcost("absorbStamina")
			if _s.SuH_PCSxp >= absorbstaminacost
				_s.SuH_PCSxp -= absorbstaminacost
				_s.SuH_PCSabsorbstamina += 1
				SetTextOptionValue(id10, _s.SuH_PCSabsorbstamina+" ["+_f.PC_getHeartXPcost("absorbStamina")+" XP]") ;heart.absorbstamina
			endIf
		elseif(option == id11) ;SuH_PCSfluidhealth
			int cost = _f.PC_getHeartXPcost("fluidHealth")
			if _s.SuH_PCSxp >= cost
				_s.SuH_PCSxp -= cost
				_s.SuH_PCSfluidhealth += 1
				SetTextOptionValue(id11, _s.SuH_PCSfluidhealth+" ["+_f.PC_getHeartXPcost("fluidHealth")+" XP]") ;heart.spermhealth
			endIf
		elseif(option == id12) ;SuH_PCSfluidmagicka
			int cost = _f.PC_getHeartXPcost("fluidMagicka")
			if _s.SuH_PCSxp >= cost
				_s.SuH_PCSxp -= cost
				_s.SuH_PCSfluidmagicka += 1
				SetTextOptionValue(id12, _s.SuH_PCSfluidmagicka+" ["+_f.PC_getHeartXPcost("fluidMagicka")+" XP]") ;heart.spermmagicka
			endIf
		elseif(option == id13) ;SuH_PCSfluidstamina
			int cost = _f.PC_getHeartXPcost("fluidStamina")
			if _s.SuH_PCSxp >= cost
				_s.SuH_PCSxp -= cost
				_s.SuH_PCSfluidstamina += 1
				SetTextOptionValue(id13, _s.SuH_PCSfluidstamina+" ["+_f.PC_getHeartXPcost("fluidStamina")+" XP]") ;heart.spermstamina
			endIf
		elseif(option == id7) ;heart.xpgain
			int xpgaincost = _f.PC_getHeartXPcost("xpGain")
			if _s.SuH_PCSxp >= xpgaincost
				_s.SuH_PCSxp -= xpgaincost
				_s.SuH_PCSxpgain += 2
				SetTextOptionValue(id7, _s.SuH_PCSxpgain+"% ["+_f.PC_getHeartXPcost("xpGain")+" XP]") ;heart.xpgain
			endIf
		elseif(option == id4) ;SuH_PCSsexbonusmax
			int sexbonuscost = _f.PC_getHeartXPcost("sexBonus")
			if _s.SuH_PCSxp >= sexbonuscost
				_s.SuH_PCSxp -= sexbonuscost
				_s.SuH_PCSsexbonusmax += 500
				int sexbonustime = Math.Ceiling( ((_s.SuH_PCSsexbonusmax * 1.0) / _s.SuH_PCSsexbonushour) * 60.0 )
				SetTextOptionValue(id4, sexbonustime+"min ["+_f.PC_getHeartXPcost("sexBonus")+" XP]") ;heart.stacksex
			endIf
		elseif(option == id5) ;SuH_PCSfluidbonus
			int fluidbonuscost = _f.PC_getHeartXPcost("fluidBonus")
			if _s.SuH_PCSxp >= fluidbonuscost
				_s.SuH_PCSxp -= fluidbonuscost
				_s.SuH_PCSfluidbonusmax += 500
				int fluidbonustime = Math.Ceiling( ((_s.SuH_PCSfluidbonusmax * 1.0) / _s.SuH_PCSfluidbonushour) * 60.0 )
				SetTextOptionValue(id5, fluidbonustime+"min ["+_f.PC_getHeartXPcost("fluidBonus")+" XP]") ;heart.stacksex
			endIf
		endIf
		_f.PC_recalculateBDSM() ; recalculate BDSM values
		SetTextOptionValue(id0, _s.SuH_PCSxp) ; set HeartXP display
		SetTextOptionValue(id17, "B:"+_s.SuH_PCSbpoint+" D:"+_s.SuH_PCSdpoint+" S:"+_s.SuH_PCSspoint+" M:"+_s.SuH_PCSmpoint) ; set BDSM display
	elseIf(CurrentPage == "Skill Levels")
		if(option == id4) ;skill.alchemy
			int skilllvl = playerRef.GetBaseActorValue("alchemy") as int
			int skillcost = _f.PC_getSkillXPcost("alchemy")
			if _s.SuH_PCSskillxp >= skillcost
				_s.SuH_PCSskillxp -= skillcost
				Game.AdvanceSkill("Alchemy", (((skilllvl * 0.05) + 1) * 266.666))
				if skilllvl < playerRef.GetBaseActorValue("alchemy")
					skilllvl = playerRef.GetBaseActorValue("alchemy") as int
					Debug.MessageBox("Alchemy level Increased to "+skilllvl)
				else
					Debug.MessageBox("Alchemy XP Increased")
				endIf
				SetTextOptionValue(id4, skilllvl+" ["+_f.PC_getSkillXPcost("alchemy")+" SkillXP]")
			endIf
		elseif(option == id13) ;skill.alteration
			int skilllvl = playerRef.GetBaseActorValue("alteration") as int
			int skillcost = _f.PC_getSkillXPcost("alteration")
			if _s.SuH_PCSskillxp >= skillcost
				_s.SuH_PCSskillxp -= skillcost
				Game.AdvanceSkill("alteration", (((skilllvl * 0.05) + 1) * 66.666))
				if skilllvl < playerRef.GetBaseActorValue("alteration")
					skilllvl = playerRef.GetBaseActorValue("alteration") as int
					Debug.MessageBox("Alteration level Increased to "+skilllvl)
				else
					Debug.MessageBox("Alteration XP Increased")
				endIf
				SetTextOptionValue(id13, skilllvl+" ["+_f.PC_getSkillXPcost("alteration")+" SkillXP]")
			endIf
		elseif(option == id5) ;skill.block
			int skilllvl = playerRef.GetBaseActorValue("block") as int
			int skillcost = _f.PC_getSkillXPcost("block")
			if _s.SuH_PCSskillxp >= skillcost
				_s.SuH_PCSskillxp -= skillcost
				Game.AdvanceSkill("block", (((skilllvl * 0.05) + 1) * 24.69))
				if skilllvl < playerRef.GetBaseActorValue("block")
					skilllvl = playerRef.GetBaseActorValue("block") as int
					Debug.MessageBox("Block level Increased to "+skilllvl)
				else
					Debug.MessageBox("Block XP Increased")
				endIf
				SetTextOptionValue(id5, skilllvl+" ["+_f.PC_getSkillXPcost("block")+" SkillXP]")
			endIf
		elseif(option == id14) ;skill.conjuration
			int skilllvl = playerRef.GetBaseActorValue("conjuration") as int
			int skillcost = _f.PC_getSkillXPcost("conjuration")
			if _s.SuH_PCSskillxp >= skillcost
				_s.SuH_PCSskillxp -= skillcost
				Game.AdvanceSkill("conjuration", (((skilllvl * 0.05) + 1) * 95.238))
				if skilllvl < playerRef.GetBaseActorValue("conjuration")
					skilllvl = playerRef.GetBaseActorValue("conjuration") as int
					Debug.MessageBox("Conjuration level Increased to "+skilllvl)
				else
					Debug.MessageBox("Conjuration XP Increased")
				endIf
				SetTextOptionValue(id14, skilllvl+" ["+_f.PC_getSkillXPcost("conjuration")+" SkillXP]")
			endIf
		elseif(option == id6) ;skill.destruction
			int skilllvl = playerRef.GetBaseActorValue("destruction") as int
			int skillcost = _f.PC_getSkillXPcost("destruction")
			if _s.SuH_PCSskillxp >= skillcost
				_s.SuH_PCSskillxp -= skillcost
				Game.AdvanceSkill("destruction", (((skilllvl * 0.05) + 1) * 148.148))
				if skilllvl < playerRef.GetBaseActorValue("destruction")
					skilllvl = playerRef.GetBaseActorValue("destruction") as int
					Debug.MessageBox("Destruction level Increased to "+skilllvl)
				else
					Debug.MessageBox("Destruction XP Increased")
				endIf
				SetTextOptionValue(id6, skilllvl+" ["+_f.PC_getSkillXPcost("destruction")+" SkillXP]")
			endIf
		elseif(option == id15) ;skill.enchanting
			int skilllvl = playerRef.GetBaseActorValue("enchanting") as int
			int skillcost = _f.PC_getSkillXPcost("enchanting")
			if _s.SuH_PCSskillxp >= skillcost
				_s.SuH_PCSskillxp -= skillcost
				Game.AdvanceSkill("enchanting", (((skilllvl * 0.05) + 1) * 0.222))
				if skilllvl < playerRef.GetBaseActorValue("enchanting")
					skilllvl = playerRef.GetBaseActorValue("enchanting") as int
					Debug.MessageBox("Enchanting level Increased to "+skilllvl)
				else
					Debug.MessageBox("Enchanting XP Increased")
				endIf
				SetTextOptionValue(id15, skilllvl+" ["+_f.PC_getSkillXPcost("enchanting")+" SkillXP]")
			endIf
		elseif(option == id7) ;skill.heavyarmor
			int skilllvl = playerRef.GetBaseActorValue("heavyarmor") as int
			int skillcost = _f.PC_getSkillXPcost("heavyarmor")
			if _s.SuH_PCSskillxp >= skillcost
				_s.SuH_PCSskillxp -= skillcost
				Game.AdvanceSkill("heavyarmor", (((skilllvl * 0.05) + 1) * 52.63))
				if skilllvl < playerRef.GetBaseActorValue("heavyarmor")
					skilllvl = playerRef.GetBaseActorValue("heavyarmor") as int
					Debug.MessageBox("Heavy Armor level Increased to "+skilllvl)
				else
					Debug.MessageBox("Heavy Armor XP Increased")
				endIf
				SetTextOptionValue(id7, skilllvl+" ["+_f.PC_getSkillXPcost("heavyarmor")+" SkillXP]")
			endIf
		elseif(option == id16) ;skill.illusion
			int skilllvl = playerRef.GetBaseActorValue("illusion") as int
			int skillcost = _f.PC_getSkillXPcost("illusion")
			if _s.SuH_PCSskillxp >= skillcost
				_s.SuH_PCSskillxp -= skillcost
				Game.AdvanceSkill("illusion", (((skilllvl * 0.05) + 1) * 43.478))
				if skilllvl < playerRef.GetBaseActorValue("illusion")
					skilllvl = playerRef.GetBaseActorValue("illusion") as int
					Debug.MessageBox("Illusion level Increased to "+skilllvl)
				else
					Debug.MessageBox("Illusion XP Increased")
				endIf
				SetTextOptionValue(id16, skilllvl+" ["+_f.PC_getSkillXPcost("illusion")+" SkillXP]")
			endIf
		elseif(option == id8) ;skill.lightarmor
			int skilllvl = playerRef.GetBaseActorValue("lightarmor") as int
			int skillcost = _f.PC_getSkillXPcost("lightarmor")
			if _s.SuH_PCSskillxp >= skillcost
				_s.SuH_PCSskillxp -= skillcost
				Game.AdvanceSkill("lightarmor", (((skilllvl * 0.05) + 1) * 50))
				if skilllvl < playerRef.GetBaseActorValue("lightarmor")
					skilllvl = playerRef.GetBaseActorValue("lightarmor") as int
					Debug.MessageBox("Light Armor level Increased to "+skilllvl)
				else
					Debug.MessageBox("Light Armor XP Increased")
				endIf
				SetTextOptionValue(id8, skilllvl+" ["+_f.PC_getSkillXPcost("lightarmor")+" SkillXP]")
			endIf
		elseif(option == id17) ;skill.lockpicking
			int skilllvl = playerRef.GetBaseActorValue("lockpicking") as int
			int skillcost = _f.PC_getSkillXPcost("lockpicking")
			if _s.SuH_PCSskillxp >= skillcost
				_s.SuH_PCSskillxp -= skillcost
				Game.AdvanceSkill("lockpicking", (((skilllvl * 0.05) + 1) * 4.444))
				if skilllvl < playerRef.GetBaseActorValue("lockpicking")
					skilllvl = playerRef.GetBaseActorValue("lockpicking") as int
					Debug.MessageBox("Lockpicking level Increased to "+skilllvl)
				else
					Debug.MessageBox("Lockpicking XP Increased")
				endIf
				SetTextOptionValue(id17, skilllvl+" ["+_f.PC_getSkillXPcost("lockpicking")+" SkillXP]")
			endIf
		elseif(option == id9) ;skill.marksman
			int skilllvl = playerRef.GetBaseActorValue("marksman") as int
			int skillcost = _f.PC_getSkillXPcost("marksman")
			if _s.SuH_PCSskillxp >= skillcost
				_s.SuH_PCSskillxp -= skillcost
				Game.AdvanceSkill("marksman", (((skilllvl * 0.05) + 1) * 21.504))
				if skilllvl < playerRef.GetBaseActorValue("marksman")
					skilllvl = playerRef.GetBaseActorValue("marksman") as int
					Debug.MessageBox("Marksman level Increased to "+skilllvl)
				else
					Debug.MessageBox("Marksman XP Increased")
				endIf
				SetTextOptionValue(id9, skilllvl+" ["+_f.PC_getSkillXPcost("marksman")+" SkillXP]")
			endIf
		elseif(option == id18) ;skill.onehanded
			int skilllvl = playerRef.GetBaseActorValue("onehanded") as int
			int skillcost = _f.PC_getSkillXPcost("onehanded")
			if _s.SuH_PCSskillxp >= skillcost
				_s.SuH_PCSskillxp -= skillcost
				Game.AdvanceSkill("onehanded", (((skilllvl * 0.05) + 1) * 31.746))
				if skilllvl < playerRef.GetBaseActorValue("onehanded")
					skilllvl = playerRef.GetBaseActorValue("onehanded") as int
					Debug.MessageBox("One Handed level Increased to "+skilllvl)
				else
					Debug.MessageBox("One Handed XP Increased")
				endIf
				SetTextOptionValue(id18, skilllvl+" ["+_f.PC_getSkillXPcost("onehanded")+" SkillXP]")
			endIf
		elseif(option == id10) ;skill.pickpocket
			int skilllvl = playerRef.GetBaseActorValue("pickpocket") as int
			int skillcost = _f.PC_getSkillXPcost("pickpocket")
			if _s.SuH_PCSskillxp >= skillcost
				_s.SuH_PCSskillxp -= skillcost
				Game.AdvanceSkill("pickpocket", (((skilllvl * 0.05) + 1) * 24.69))
				if skilllvl < playerRef.GetBaseActorValue("pickpocket")
					skilllvl = playerRef.GetBaseActorValue("pickpocket") as int
					Debug.MessageBox("Pickpocket level Increased to "+skilllvl)
				else
					Debug.MessageBox("Pickpocket XP Increased")
				endIf
				SetTextOptionValue(id10, skilllvl+" ["+_f.PC_getSkillXPcost("pickpocket")+" SkillXP]")
			endIf
		elseif(option == id19) ;skill.restoration
			int skilllvl = playerRef.GetBaseActorValue("restoration") as int
			int skillcost = _f.PC_getSkillXPcost("restoration")
			if _s.SuH_PCSskillxp >= skillcost
				_s.SuH_PCSskillxp -= skillcost
				Game.AdvanceSkill("restoration", (((skilllvl * 0.05) + 1) * 100))
				if skilllvl < playerRef.GetBaseActorValue("restoration")
					skilllvl = playerRef.GetBaseActorValue("restoration") as int
					Debug.MessageBox("Restoration level Increased to "+skilllvl)
				else
					Debug.MessageBox("Restoration XP Increased")
				endIf
				SetTextOptionValue(id19, skilllvl+" ["+_f.PC_getSkillXPcost("restoration")+" SkillXP]")
			endIf
		elseif(option == id11) ;skill.smithing
			int skilllvl = playerRef.GetBaseActorValue("smithing") as int
			int skillcost = _f.PC_getSkillXPcost("smithing")
			if _s.SuH_PCSskillxp >= skillcost
				_s.SuH_PCSskillxp -= skillcost
				Game.AdvanceSkill("smithing", (((skilllvl * 0.05) + 1) * 200))
				if skilllvl < playerRef.GetBaseActorValue("smithing")
					skilllvl = playerRef.GetBaseActorValue("smithing") as int
					Debug.MessageBox("Smithing level Increased to "+skilllvl)
				else
					Debug.MessageBox("Smithing XP Increased")
				endIf
				SetTextOptionValue(id11, skilllvl+" ["+_f.PC_getSkillXPcost("smithing")+" SkillXP]")
			endIf
		elseif(option == id20) ;skill.sneak
			int skilllvl = playerRef.GetBaseActorValue("sneak") as int
			int skillcost = _f.PC_getSkillXPcost("sneak")
			if _s.SuH_PCSskillxp >= skillcost
				_s.SuH_PCSskillxp -= skillcost
				Game.AdvanceSkill("sneak", (((skilllvl * 0.05) + 1) * 17.776))
				if skilllvl < playerRef.GetBaseActorValue("sneak")
					skilllvl = playerRef.GetBaseActorValue("sneak") as int
					Debug.MessageBox("Sneak level Increased to "+skilllvl)
				else
					Debug.MessageBox("Sneak XP Increased")
				endIf
				SetTextOptionValue(id20, skilllvl+" ["+_f.PC_getSkillXPcost("sneak")+" SkillXP]")
			endIf
		elseif(option == id12) ;skill.speechcraft
			int skilllvl = playerRef.GetBaseActorValue("speechcraft") as int
			int skillcost = _f.PC_getSkillXPcost("speechcraft")
			if _s.SuH_PCSskillxp >= skillcost
				_s.SuH_PCSskillxp -= skillcost
				Game.AdvanceSkill("speechcraft", (((skilllvl * 0.05) + 1) * 555.554))
				if skilllvl < playerRef.GetBaseActorValue("speechcraft")
					skilllvl = playerRef.GetBaseActorValue("speechcraft") as int
					Debug.MessageBox("Speechcraft level Increased to "+skilllvl)
				else
					Debug.MessageBox("Speechcraft XP Increased")
				endIf
				SetTextOptionValue(id12, skilllvl+" ["+_f.PC_getSkillXPcost("speechcraft")+" SkillXP]")
			endIf
		elseif(option == id21) ;skill.twohanded
			int skilllvl = playerRef.GetBaseActorValue("twohanded") as int
			int skillcost = _f.PC_getSkillXPcost("twohanded")
			if _s.SuH_PCSskillxp >= skillcost
				_s.SuH_PCSskillxp -= skillcost
				Game.AdvanceSkill("twohanded", (((skilllvl * 0.05) + 1) * 33.612))
				if skilllvl < playerRef.GetBaseActorValue("twohanded")
					skilllvl = playerRef.GetBaseActorValue("twohanded") as int
					Debug.MessageBox("Two Handed level Increased to "+skilllvl)
				else
					Debug.MessageBox("Two Handed XP Increased")
				endIf
				SetTextOptionValue(id21, skilllvl+" ["+_f.PC_getSkillXPcost("twohanded")+" SkillXP]")
			endIf
		endIf
		SetTextOptionValue(id0, _s.SuH_PCSskillxp) ; set SkillXP display
	;	Passives
	elseIf(CurrentPage == "Passives")
		if(option == id2) ;spell.xp
				int bdsmrankcost = _f.PC_getHeartXPcost("BDSMrank")
			if _s.SuH_PCSxp >= bdsmrankcost
				_s.SuH_PCSxp -= bdsmrankcost
				_s.SuH_rank_bdsm += 1
				_f.PC_recalculateBDSM()
				debug.MessageBox("BodyDesireSoulMind Rating has been increased!")
				SetTextOptionValue(id1, "B:"+_s.SuH_PCSbpoint+" D:"+_s.SuH_PCSdpoint+" S:"+_s.SuH_PCSspoint+" M:"+_s.SuH_PCSmpoint)
				SetTextOptionValue(id2, _f.PC_getHeartXPcost("BDSMrank")+" XP")
			endIf
		elseif(option == id3) ;spell.reset
			_f.PassiveReset()
			ForcePageReset()
		elseif(option == id44) ;SuH_rank_soultap
			if	_s.SuH_rank_soultap >= 5
				debug.MessageBox("Soul Siphon has reached the max rank available on this path!")
			elseif _s.SuH_PCScapmagicka < 26
				debug.MessageBox("Not enough Magicka Cap to increase passive level")
			else
				_s.SuH_rank_soultap += 1
				_f.PC_addMagickaDown(25)
				SetTextOptionValue(id32, "rank "+_s.SuH_rank_soultap) ;spell.perfectorgasm
				SetTextOptionValue(id44, _s.SuH_rank_soultap) ;spell.perfectorgasmrank
			endIf
		elseif(option == id45) ;SuH_rank_soultapplus
			if	_s.SuH_rank_soultapplus > 0
				debug.MessageBox("Soul Siphon+ already unlocked!")
			elseif _s.SuH_PCScapmagicka < 81
				debug.MessageBox("Not enough Magicka Cap to unlock")
			else
				_s.SuH_rank_soultapplus += 1
				_f.PC_addMagickaDown(80)
				SetTextOptionValue(id45, "Unlocked") ;spell.perfectorgasmrank
			endIf
		elseif(option == id38) ;spell.perfectorgasmrank
			if	_s.SuH_rank_perfectorgasm >= 95
				debug.MessageBox("Perfect Orgasm has reached the max rank available on this path!")
			elseif _s.SuH_PCScapmagicka < 16
				debug.MessageBox("Not enough Magicka Cap to increase passive level")
			else
				_s.SuH_rank_perfectorgasm += 1
				_f.PC_addMagickaDown(15)
				SetTextOptionValue(id37, "rank "+ (_s.SuH_rank_perfectorgasm + _s.SuH_rank_perfectorgasm2)) ;spell.perfectorgasm
				SetTextOptionValue(id38, _s.SuH_rank_perfectorgasm) ;spell.perfectorgasmrank
			endIf
		elseif(option == id39) ;spell.perfectorgasmrank2
			if	_s.SuH_rank_perfectorgasm2 >= 20
				debug.MessageBox("Perfect Orgasm has reached the max rank available on this path!")
			elseif _s.SuH_PCScaphealth < 16
				debug.MessageBox("Not enough Health Cap to increase passive level")
			elseif _s.SuH_PCScapmagicka < 16
				debug.MessageBox("Not enough Magicka Cap to increase passive level")
			elseif _s.SuH_PCScapstamina < 16
				debug.MessageBox("Not enough Stamina Cap to increase passive level")
			else
				_s.SuH_rank_perfectorgasm2 += 1
				_f.PC_addHealthDown(15)
				_f.PC_addMagickaDown(15)
				_f.PC_addStaminaDown(15)
				SetTextOptionValue(id37, "rank "+ (_s.SuH_rank_perfectorgasm + _s.SuH_rank_perfectorgasm2)) ;spell.perfectorgasm
				SetTextOptionValue(id39, _s.SuH_rank_perfectorgasm2) ;spell.perfectorgasmrank2
			endIf
		elseif(option == id24) ;spell.lusciousliquidsrank
			if _s.SuH_PCScaphealth < 21
				debug.MessageBox("Not enough Health Cap to increase passive level")
			else
				_s.SuH_rank_lusciousliquids += 1
				_f.PC_addHealthDown(20)
				SetTextOptionValue(id23, "rank "+ (_s.SuH_rank_lusciousliquids + _s.SuH_rank_lusciousliquids2)) ;spell.lusciousliquids
				SetTextOptionValue(id24, _s.SuH_rank_lusciousliquids) ;spell.lusciousliquidsrank
			endIf
		elseif(option == id25) ;spell.lusciousliquidsrank2
			if _s.SuH_PCScapstamina < 11
				debug.MessageBox("Not enough Stamina Cap to increase passive level")
			else
				_f.PC_addStaminaDown(10)
				_s.SuH_rank_lusciousliquids2 += 1
				SetTextOptionValue(id23, "rank "+ (_s.SuH_rank_lusciousliquids + _s.SuH_rank_lusciousliquids2)) ;spell.lusciousliquids
				SetTextOptionValue(id25, _s.SuH_rank_lusciousliquids2) ;spell.lusciousliquidsrank2
			endIf
		elseif(option == id5) ;spell.masochistrank
			if _s.SuH_PCScaphealth < 16
				debug.MessageBox("Not enough Health Cap to increase passive level")
			else
				_f.PC_addHealthDown(15)
				_s.SuH_rank_masochist += 1
				SetTextOptionValue(id4, "rank "+ (_s.SuH_rank_masochist + _s.SuH_rank_masochist2 + _s.SuH_rank_masochist3)) ;spell.masochist
				SetTextOptionValue(id5, _s.SuH_rank_masochist) ;spell.masochistrank
			endIf
		elseif(option == id6) ;spell.masochistrank2
			if _s.SuH_PCScaphealth < 16
				debug.MessageBox("Not enough Health Cap to increase passive level")
			else
				_f.PC_addHealthDown(15)
				_s.SuH_rank_masochist2 += 1
				SetTextOptionValue(id4, "rank "+ (_s.SuH_rank_masochist + _s.SuH_rank_masochist2 + _s.SuH_rank_masochist3)) ;spell.masochist
				SetTextOptionValue(id6, _s.SuH_rank_masochist2) ;spell.masochistrank2
			endIf
		elseif(option == id30) ;SuH_rank_masochist3
			if _s.SuH_PCScapstamina < 31
				debug.MessageBox("Not enough Stamina Cap to increase passive level")
			else
				_f.PC_addStaminaDown(30)
				_s.SuH_rank_masochist3 += 1
				SetTextOptionValue(id4, "rank "+ (_s.SuH_rank_masochist + _s.SuH_rank_masochist2 + _s.SuH_rank_masochist3)) ;spell.masochist
				SetTextOptionValue(id30, _s.SuH_rank_masochist3) ;SuH_rank_masochist3
			endIf
		elseif(option == id34) ;spell.selfstackerrank
			if _s.SuH_PCScapStamina < 11
				debug.MessageBox("Not enough Stamina Cap to increase passive level")
			else
				_f.PC_addStaminaDown(10)
				_s.SuH_rank_selfstacker += 1
				SetTextOptionValue(id33, "rank "+_s.SuH_rank_selfstacker) ;spell.selfstacker
				SetTextOptionValue(id34, _s.SuH_rank_selfstacker) ;spell.selfstackerrank
			endIf
		elseif(option == id43) ;spell.selfstackerrankplus
			if _s.SuH_rank_selfstackerplus > 0
				debug.MessageBox("Self Indulgent+ Already Unlocked")
			elseIf _s.SuH_PCScapStamina < 121
				debug.MessageBox("Not enough Stamina Cap to unlock")
			else
				_f.PC_addStaminaDown(120)
				_s.SuH_rank_selfstackerplus += 1
				SetTextOptionValue(id43, "Unlocked") ;spell.selfstackerrank
			endIf
		elseif(option == id14) ;spell.savingessencerank
			if _s.SuH_rank_savingessence > 13
				debug.MessageBox("Saving Essence has reached the max rank available on this path!")
			elseif _s.SuH_PCScaphealth < 31
				debug.MessageBox("Not enough Health Cap to increase passive level")
			else
				_f.PC_addHealthDown(30)
				_s.SuH_rank_savingessence += 1
				SetTextOptionValue(id13, "rank "+(_s.SuH_rank_savingessence + _s.SuH_rank_savingessence2)) ;spell.savingessence
				SetTextOptionValue(id14, _s.SuH_rank_savingessence) ;spell.savingessencerank
			endIf
		elseif(option == id15) ;spell.savingessencerank2
			if _s.SuH_PCScapmagicka < 31
				debug.MessageBox("Not enough Magicka Cap to increase passive level")
			else
				_f.PC_addMagickaDown(30)
				_s.SuH_rank_savingessence2 += 1
				SetTextOptionValue(id13, "rank "+(_s.SuH_rank_savingessence + _s.SuH_rank_savingessence2)) ;spell.savingessence
				SetTextOptionValue(id15, _s.SuH_rank_savingessence2) ;spell.savingessencerank2
			endIf
		elseif(option == id22) ;spell.giftedconsentrank
			if _s.SuH_PCScapmagicka < 11
				debug.MessageBox("Not enough Magicka Cap to increase passive level")
			elseif _s.SuH_PCScapstamina < 6
				debug.MessageBox("Not enough Stamina Cap to increase passive level")
			else
				_f.PC_addMagickaDown(10)
				_f.PC_addStaminaDown(5)
				_s.SuH_rank_giftedconsent += 1
				SetTextOptionValue(id21, "rank "+_s.SuH_rank_giftedconsent) ;spell.giftedconsent
				SetTextOptionValue(id22, _s.SuH_rank_giftedconsent) ;spell.giftedconsentrank
			endIf
		elseif(option == id31) ;spell.giftedconsentrankplus
			if _s.SuH_rank_giftedconsentplus > 0
				debug.MessageBox("Gifted Consent+ Already Unlocked")
			elseif _s.SuH_PCScaphealth < 41
				debug.MessageBox("Not enough Health Cap to increase passive level")
			elseif _s.SuH_PCScapmagicka < 41
				debug.MessageBox("Not enough Magicka Cap to increase passive level")
			elseif _s.SuH_PCScapstamina < 41
				debug.MessageBox("Not enough Stamina Cap to increase passive level")
			else
				_f.PC_addHealthDown(40)
				_f.PC_addMagickaDown(40)
				_f.PC_addStaminaDown(40)
				_s.SuH_rank_giftedconsentplus += 1
				SetTextOptionValue(id31, "Unlocked") ;spell.giftedconsentrank
			endIf
		elseif(option == id19) ;spell.deviouspartnerrank
			if _s.SuH_rank_deviouspartner >= 5
				debug.MessageBox("Devious Partner has reached the max rank available on this path!")
			elseif _s.SuH_PCScapstamina < 21
				debug.MessageBox("Not enough Stamina Cap to increase passive level")
			else
				_f.PC_addStaminaDown(20)
				_s.SuH_rank_deviouspartner += 1
				SetTextOptionValue(id18, "rank "+(_s.SuH_rank_deviouspartner + _s.SuH_rank_deviouspartner2))
				SetTextOptionValue(id19, _s.SuH_rank_deviouspartner) ;spell.deviouspartnerrank
			endIf
		elseif(option == id20) ;spell.deviouspartnerrank2
			if _s.SuH_rank_deviouspartner2 >= 10
				debug.MessageBox("Devious Partner has reached the max rank available on this path!")
			elseIf _s.SuH_PCScapmagicka < 31
				debug.MessageBox("Not enough Magicka Cap to increase passive level")
			else
				_f.PC_addMagickaDown(30)
				_s.SuH_rank_deviouspartner2 += 1
				SetTextOptionValue(id18, "rank "+(_s.SuH_rank_deviouspartner + _s.SuH_rank_deviouspartner2))
				SetTextOptionValue(id20, _s.SuH_rank_deviouspartner2) ;spell.deviouspartnerrank2
			endif
		elseif(option == id27) ;spell.formalbeautyrank
			If _s.SuH_PCScaphealth < 26
				debug.MessageBox("Not enough Health Cap to increase passive level")
			else
				_f.PC_addHealthDown(25)
				_s.SuH_rank_formalbeauty += 1
				SetTextOptionValue(id26, "rank "+_s.SuH_rank_formalbeauty) ;spell.formalbeauty
				SetTextOptionValue(id27, _s.SuH_rank_formalbeauty) ;spell.formalbeautyrank
			endIf
		elseif(option == id17) ;spell.seducerrank
			if _s.SuH_rank_seducer >= 5
				debug.MessageBox("Seducer has reached the max rank available on this path!")
			elseif _s.SuH_PCScaphealth < 31
				debug.MessageBox("Not enough Health Cap to increase passive level")
			elseif _s.SuH_PCScapmagicka < 31
				debug.MessageBox("Not enough Magicka Cap to increase passive level")
			elseif _s.SuH_PCScapstamina < 31
				debug.MessageBox("Not enough Stamina Cap to increase passive level")
			else
				_f.PC_addHealthDown(30)
				_f.PC_addMagickaDown(30)
				_f.PC_addStaminaDown(30)
				_s.SuH_rank_seducer += 1
				SetTextOptionValue(id16, "rank "+(_s.SuH_rank_seducer + _s.SuH_rank_seducer2)) ;spell.seducer
				SetTextOptionValue(id17, _s.SuH_rank_seducer) ;spell.seducerrank
			endIf
		elseif(option == id28) ;spell.seducerrank2
			if _s.SuH_PCScapstamina < 36
				debug.MessageBox("Not enough Stamina Cap to increase passive level")
			else
				_f.PC_addStaminaDown(35)
				_s.SuH_rank_seducer2 += 1
				SetTextOptionValue(id16, "rank "+(_s.SuH_rank_seducer + _s.SuH_rank_seducer2)) ;spell.seducer
				SetTextOptionValue(id28, _s.SuH_rank_seducer2) ;spell.seducerrank
			endIf
		elseif(option == id12) ;spell.regalglowrank
			if _s.SuH_rank_regalglow >= 5
				debug.MessageBox("Regal Glow has reached the max rank available on this path!")
			elseIf _s.SuH_PCScapmagicka < 26
				debug.MessageBox("Not enough Magicka Cap to increase passive level")
			else
				_f.PC_addMagickaDown(25)
				_s.SuH_rank_regalglow += 1
				SetTextOptionValue(id11, "rank "+ _s.SuH_rank_regalglow) ;spell.regalglow
				SetTextOptionValue(id12, _s.SuH_rank_regalglow) ;spell.regalglowrank
			endIf
		elseif(option == id8) ;spell.violencerank
			if _s.SuH_rank_violence >= 1
				debug.MessageBox("Violence has reached the max rank available on this path!")
			elseIf _s.SuH_PCScaphealth < 81
				debug.MessageBox("Not enough Health Cap to increase passive level")
			else
				_f.PC_addHealthDown(80)
				_s.SuH_rank_violence += 1
				SetTextOptionValue(id7, "rank "+(_s.SuH_rank_violence + _s.SuH_rank_violence2 + _s.SuH_rank_violence3)) ;spell.violence
				SetTextOptionValue(id8, _s.SuH_rank_violence) ;spell.violencerank
			endIf
		elseif(option == id9) ;spell.violencerank2
			if _s.SuH_rank_violence2 >= 1
				debug.MessageBox("Violence has reached the max rank available on this path!")
			elseIf _s.SuH_PCScapmagicka < 81
				debug.MessageBox("Not enough Magicka Cap to increase passive level")
			else
				_f.PC_addMagickaDown(80)
				_s.SuH_rank_violence2 += 1
				SetTextOptionValue(id7, "rank "+(_s.SuH_rank_violence + _s.SuH_rank_violence2 + _s.SuH_rank_violence3)) ;spell.violence
				SetTextOptionValue(id9, _s.SuH_rank_violence2) ;spell.violencerank2
			endIf
		elseif(option == id10) ;spell.violencerank3
			if _s.SuH_rank_violence3 >= 1
				debug.MessageBox("Violence has reached the max rank available on this path!")
			elseIf _s.SuH_PCScapstamina < 81
				debug.MessageBox("Not enough Stamina Cap to increase passive level")
			else
				_f.PC_addStaminaDown(80)
				_s.SuH_rank_violence3 += 1
				SetTextOptionValue(id7, "rank "+(_s.SuH_rank_violence + _s.SuH_rank_violence2 + _s.SuH_rank_violence3)) ;spell.violence
				SetTextOptionValue(id10, _s.SuH_rank_violence3) ;spell.violencerank3
			endIf
		elseif(option == id36) ;spell.healthyabsorberrank
			if _s.SuH_PCScaphealth < 6
				debug.MessageBox("Not enough Health Cap to increase passive level")
			elseif _s.SuH_PCScapmagicka < 6
				debug.MessageBox("Not enough Magicka Cap to increase passive level")
			elseif _s.SuH_PCScapstamina < 6
				debug.MessageBox("Not enough Stamina Cap to increase passive level")
			else
				_f.PC_addHealthDown(5)
				_f.PC_addMagickaDown(5)
				_f.PC_addStaminaDown(5)
				_s.SuH_rank_healthyabsorber += 1
				SetTextOptionValue(id35, "rank "+ _s.SuH_rank_healthyabsorber) ;spell.healthyabsorber
				SetTextOptionValue(id36, _s.SuH_rank_healthyabsorber) ;spell.healthyabsorberrank
			endIf
		elseif(option == id41) ;spell.capexcelrank
			if _s.SuH_PCScaphealth < 16
				debug.MessageBox("Not enough Health Cap to increase passive level")
			elseif _s.SuH_PCScapmagicka < 16
				debug.MessageBox("Not enough Magicka Cap to increase passive level")
			elseif _s.SuH_PCScapstamina < 16
				debug.MessageBox("Not enough Stamina Cap to increase passive level")
			else
				_f.PC_addHealthDown(15)
				_f.PC_addMagickaDown(15)
				_f.PC_addStaminaDown(15)
				_s.SuH_rank_capexcel += 1
				SetTextOptionValue(id40, "rank "+(_s.SuH_rank_capexcel + _s.SuH_rank_capexcel2)) ;spell.capexcel
				SetTextOptionValue(id41, _s.SuH_rank_capexcel) ;spell.capexcelrank
			endIf
		elseif(option == id42) ;spell.capexcelrank2
			if _s.SuH_PCScaphealth < 11
				debug.MessageBox("Not enough Health Cap to increase passive level")
			elseif _s.SuH_PCScapmagicka < 11
				debug.MessageBox("Not enough Magicka Cap to increase passive level")
			elseif _s.SuH_PCScapstamina < 11
				debug.MessageBox("Not enough Stamina Cap to increase passive level")
			else
				_f.PC_addHealthDown(10)
				_f.PC_addMagickaDown(10)
				_f.PC_addStaminaDown(10)
				_s.SuH_rank_capexcel2 += 1
				SetTextOptionValue(id40, "rank "+(_s.SuH_rank_capexcel + _s.SuH_rank_capexcel2)) ;spell.capexcel
				SetTextOptionValue(id42, _s.SuH_rank_capexcel2) ;spell.capexcelrank2
			endIf
		elseif(option == id29) ;spell.capexcelrankplus
			if _s.SuH_rank_capexcelplus > 0
				debug.MessageBox("Cap Excel+ Already Unlocked")
			elseif _s.SuH_PCScapmagicka < 61
				debug.MessageBox("Not enough Magicka Cap to increase passive level")
			elseif _s.SuH_PCScapstamina < 61
				debug.MessageBox("Not enough Stamina Cap to increase passive level")
			else
				_f.PC_addMagickaDown(60)
				_f.PC_addStaminaDown(60)
				_s.SuH_rank_capexcelplus += 1
				SetTextOptionValue(id29, "unlocked") ;spell.capexcelrank2
			endIf
		endIf
		setstatusdisplay()
	elseif(CurrentPage == "Actives")
		if(option == id4)
			if _s.SuH_rank_sexualentice > 2 ; Caps at tier 3
				debug.MessageBox("Sexual Entice has reached its max available Tier")
			elseif _s.SuH_PCScaphealth < 26
				debug.MessageBox("Not enough Health Cap to increase tier")
			elseif _s.SuH_PCScapmagicka < 26
				debug.MessageBox("Not enough Magicka Cap to increase tier")
			elseif _s.SuH_PCScapstamina < 26
				debug.MessageBox("Not enough Stamina Cap to increase tier")
			else ; reduce status, increase rank, and set menu text
				_f.PC_addHealthDown(25)
				_f.PC_addMagickaDown(25)
				_f.PC_addStaminaDown(25)
				_s.SuH_rank_sexualentice += 1
				if _s.SuH_rank_sexualentice == 2
					SetTextOptionValue(id1, "Tier 2")
				else
					SetTextOptionValue(id1, "[Tier 3]")
				endIf
			endIf
		elseif(option == id5)
			if _s.SuH_rank_sexualenrage > 2 ; Caps at tier 3
				debug.MessageBox("Sexual Enrage has reached its max available Tier")
			elseif _s.SuH_PCScaphealth < 26
				debug.MessageBox("Not enough Health Cap to increase tier")
			elseif _s.SuH_PCScapmagicka < 26
				debug.MessageBox("Not enough Magicka Cap to increase tier")
			elseif _s.SuH_PCScapstamina < 26
				debug.MessageBox("Not enough Stamina Cap to increase tier")
			else ; reduce status, increase rank, and set menu text
				_f.PC_addHealthDown(25)
				_f.PC_addMagickaDown(25)
				_f.PC_addStaminaDown(25)
				_s.SuH_rank_sexualenrage += 1
				if _s.SuH_rank_sexualenrage == 2
					SetTextOptionValue(id2, "Tier 2")
				else
					SetTextOptionValue(id2, "[Tier 3]")
				endIf
			endIf
		elseif(option == id6) ;spell.reset
			_f.PassiveReset()
			ForcePageReset()
		endIf
		setstatusdisplay()
	elseif(CurrentPage == "Soul Pets")
		int resetwarning = 1
		if option == id5 ; summon pet
			if _s.SuH_petactorbases[petselectedslot] != none
				_f.SoulPetSummon(petselectedslot) ; summon pet and display message
				debug.MessageBox(_s.SuH_petnames[petselectedslot]+" Summoned")
				SetTextOptionValue(id1, _s.SuH_petnames[_s.SuH_petactive]) ; update selected pet name display
				SetTextOptionValue(id10, "Summoned") ; update Active Status display
			endIf
		elseif option == id6 ; dismiss active pet
			if _s.SuH_petactive >= 0
				_f.SoulPetDismiss() ; dismiss pet and display message
				debug.MessageBox("Active Pet "+_s.SuH_petnames[petselectedslot]+" Dismissed")
				SetTextOptionValue(id1, " ") ; update selected pet name display
			endIf
		elseif option == id7 ; unsummon selected pet
			if _s.SuH_petactoralive[petselectedslot] != none && _s.SuH_petactoralive[petselectedslot].IsDisabled() == false
				if _s.SuH_Frame_Sexlab > 0 && _s.SexLab.ValidateActor(_s.SuH_petactoralive[petselectedslot]) == -10
					debug.MessageBox("Soul Pets can't be Unsummoned while In-Act")
				else
					if petselectedslot == _s.SuH_petactive
						SetTextOptionValue(id1, " ") ; update active pet name display
					endIf
					SetTextOptionValue(id10, "Returned") ; update Active Status display
					 _f.SoulPetDeSummon(petselectedslot) ; unsummon pet and display message
					debug.MessageBox(_s.SuH_petnames[petselectedslot]+" Returned")
				endIf
			endIf
		elseif option == id9 ; Swap pet slot
			if petmenuoption != 1 ; if menu option is not swap pet
				resetwarning = 0
				petmenuoption = 1 ; set pet menu option to swap slot
				SetTextOptionValue(id3, "Select Second Slot to Swap With ") ; update selected pet name display
				debug.MessageBox("Select another slot to swap the currently selected pet slot with the newly selected pet slot. Re-select this option to cancel.")
			else
				petmenuoption = 0 ; reset menu option
			endIf
		elseif option == id4 ; Remove pet
			resetwarning = 0
			if petdeletewarning == 0
				petdeletewarning += 1
				SetTextOptionValue(id4, "Are you sure?") ; update selected pet name display
			elseif petdeletewarning == 1
				petdeletewarning += 1
				SetTextOptionValue(id4, "Are you sure you're sure?") ; update selected pet name display
			elseif petdeletewarning == 2
				if _s.SuH_Frame_Sexlab > 0 && _s.SexLab.ValidateActor(_s.SuH_petactoralive[petselectedslot]) == -10
					debug.MessageBox("Soul Pets can't be removed while In-Act")
				else
					_f.SoulPetRemove(petselectedslot) ; summon pet and display message
					petdeletewarning = 0
					ForcePageReset() ; Reset page to update pet slot count and menu entries properly
				endIf
			endIf
		else ; Pet Slot Selected?
			int i = 0 ; scan pet slot array for selected entry
			while i < petselectarray.Length
				if option == petslotarray[i] ; if slot found
					if i != petselectedslot ; if slot not already selected
						if petmenuoption == 1 ; if Swap Pet is selected
							if _s.SuH_petactorbases[i] != none ; if swap to pet is valid
								if petselectedslot == _s.SuH_petactive ; if slot selected is equal to active pet
									_s.SuH_petactive = i
								elseif i == _s.SuH_petactive ; if slot to swap to is active pet
									_s.SuH_petactive = petselectedslot
								endIf
								int x = _s.SuH_petlevels[i] ; swap levels
								_s.SuH_petlevels[i] = _s.SuH_petlevels[petselectedslot]
								_s.SuH_petlevels[petselectedslot] = x
								x = _s.SuH_petxps[i] ; swap xp
								_s.SuH_petxps[i] = _s.SuH_petxps[petselectedslot]
								_s.SuH_petxps[petselectedslot] = x
								x = _s.SuH_pettrait0[i] ; swap trait
								_s.SuH_pettrait0[i] = _s.SuH_pettrait0[petselectedslot]
								_s.SuH_pettrait0[petselectedslot] = x
								x = _s.SuH_pettrait1[i] ; swap trait
								_s.SuH_pettrait1[i] = _s.SuH_pettrait1[petselectedslot]
								_s.SuH_pettrait1[petselectedslot] = x
								x = _s.SuH_pettrait2[i] ; swap trait
								_s.SuH_pettrait2[i] = _s.SuH_pettrait2[petselectedslot]
								_s.SuH_pettrait2[petselectedslot] = x
								string y = _s.SuH_petnames[i] ; swap names
								_s.SuH_petnames[i] = _s.SuH_petnames[petselectedslot]
								_s.SuH_petnames[petselectedslot] = y
								actor k = _s.SuH_petactoralive[i] ; swap actor
								_s.SuH_petactoralive[i] = _s.SuH_petactoralive[petselectedslot]
								_s.SuH_petactoralive[petselectedslot] = k
								actorbase m = _s.SuH_petactorbases[i] ; swap actor
								_s.SuH_petactorbases[i] = _s.SuH_petactorbases[petselectedslot]
								_s.SuH_petactorbases[petselectedslot] = m
								resetwarning = 0
								petselectedslot = i
								ForcePageReset() ; reset page to update pet slots correctly
							endIf
						else
							petselectarray[petselectedslot] = false ; set old selection to false
							SetToggleOptionValue(petslotarray[petselectedslot], false) ; update menu entry
							petselectedslot = i ; set new selected slot
							petselectarray[i] = true ; set new selection to true
							SetToggleOptionValue(petslotarray[i], true) ; update menu entry
							SetTextOptionValue(id2, _s.SuH_petnames[petselectedslot]) ; update selected pet name display
							if _s.SuH_petactoralive[petselectedslot].IsDisabled() ; if pet is disabled, should indicate Returned
								SetTextOptionValue(id10, "Returned") ; update Active Status display
							elseif _s.SuH_Frame_Sexlab > 0 && _s.SexLab.ValidateActor(_s.SuH_petactoralive[petselectedslot]) == -10
								SetTextOptionValue(id10, "In-Act") ; update Active Status display
							else
								SetTextOptionValue(id10, "Summoned") ; update Active Status display
							endIf
							if _s.SuH_pettrait0[petselectedslot] > 0 ; check for pet traits, if valid rename
								SetTextOptionValue(id12, _f.PetGetTraitName(_s.SuH_pettrait0[petselectedslot])) ; update trait display
							else ; if not valid set blank entry
								SetTextOptionValue(id12, " - - - ") ; update trait display
							endIf
							if _s.SuH_pettrait1[petselectedslot] > 0
								SetTextOptionValue(id13, _f.PetGetTraitName(_s.SuH_pettrait1[petselectedslot])) ; update trait display
							else
								SetTextOptionValue(id13, " - - - ") ; update trait display
							endIf
							if _s.SuH_pettrait2[petselectedslot] > 0
								SetTextOptionValue(id14, _f.PetGetTraitName(_s.SuH_pettrait2[petselectedslot])) ; update trait display
							else
								SetTextOptionValue(id14, " - - - ") ; update trait display
							endIf
						endIf
						i = 149 ; escape array
					endIf
				endIf
				i += 1
			endWhile
		endIf
		if resetwarning > 0
			petdeletewarning = 0
			petmenuoption = 0
			SetTextOptionValue(id3, " ") ; update selected pet name display
		endIf
	elseif(CurrentPage == "Settings") ; Settings
		if(option == id2) ;setnpcabsorb
			if _s.SuH_SETalwaysabsorbbenefit > 0
				_s.SuH_SETalwaysabsorbbenefit = 0
				SetToggleOptionValue(option, FALSE) ;setnpcabsorb
			else
				_s.SuH_SETalwaysabsorbbenefit = 1
				SetToggleOptionValue(option, TRUE) ;setnpcabsorb
			endIf
		elseif(option == id46) ;SuH_SETonlyframepref
			if _s.SuH_SETonlyframepref > 0
				_s.SuH_SETonlyframepref = 0
				if _s.SuH_Frame_Sexlab > 0
					_s.SuH_Frame_Sexlab = 2
				endIf
				if _s.SuH_Frame_OStim > 0
					_s.SuH_Frame_OStim = 2
				endIf
				SetToggleOptionValue(option, FALSE) ;SuH_SETonlyframepref
			else
				_s.SuH_SETonlyframepref = 1
				if _s.SuH_framework == 1
					if _s.SuH_Frame_Sexlab > 0
						_s.SuH_Frame_Sexlab = 2
					endIf
					if _s.SuH_Frame_OStim > 1
						_s.SuH_Frame_OStim = 1
					endIf
				elseif _s.SuH_framework == 2
					if _s.SuH_Frame_OStim > 0
						_s.SuH_Frame_OStim = 2
					endIf
					if _s.SuH_Frame_Sexlab > 1
						_s.SuH_Frame_Sexlab = 1
					endIf
				endIf
				SetToggleOptionValue(option, TRUE) ;SuH_SETonlyframepref
			endIf
		elseif(option == id18) ;lustdefects
			if _s.SuH_SETarousaldefect > 0
				_s.SuH_SETarousaldefect = 0
				SetToggleOptionValue(option, FALSE)
			else
				_s.SuH_SETarousaldefect = 1
				SetToggleOptionValue(option, TRUE)
			endIf
		elseif(option == id43) ;SuH_SETslaifix
			if _s.SuH_SETslaifix > 0
				_s.SuH_SETslaifix = 0
				SetToggleOptionValue(option, FALSE)
			else
				_s.SuH_SETslaifix = 1
				SetToggleOptionValue(option, TRUE)
			endIf
		elseif(option == id6) ;SuH_SETdrainresetorgasm
			if _s.SuH_SETdrainresetorgasm > 0
				_s.SuH_SETdrainresetorgasm = 0
				SetToggleOptionValue(option, FALSE)
			else
				_s.SuH_SETdrainresetorgasm = 1
				SetToggleOptionValue(option, TRUE)
			endIf
		elseif(option == id45) ;SuH_SETrealmspellcost
			if _s.SuH_SETrealmspellcost > 0
				_s.SuH_SETrealmspellcost = 0
				SetToggleOptionValue(option, FALSE)
			else
				_s.SuH_SETrealmspellcost = 1
				SetToggleOptionValue(option, TRUE)
			endIf
		elseif(option == id5) ;status.alwaysdrainkill
			if _s.SuH_SETalwaysdrainkill > 0
				_s.SuH_SETalwaysdrainkill = 0
				SetToggleOptionValue(id5, FALSE) ;status.alwaysdrainkill
			else
				_s.SuH_SETalwaysdrainkill = 1
				SetToggleOptionValue(id5, TRUE) ;status.alwaysdrainkill
			endIf
		elseif(option == id7) ;calmaura
			if _s.SuH_SETcalmaura > 0
				_s.SuH_SETcalmaura = 0
				SetToggleOptionValue(id7, FALSE) ;calmaura
			else
				_s.SuH_SETcalmaura = 1
				SetToggleOptionValue(id7, TRUE) ;calmaura
			endIf
		elseif(option == id8) ;status.deathdrops
			if _s.SuH_SETdeathdrops > 0
				_s.SuH_SETdeathdrops = 0
				SetToggleOptionValue(id8, FALSE) ;status.deathdrops
			else
				_s.SuH_SETdeathdrops = 1
				SetToggleOptionValue(id8, TRUE) ;status.deathdrops
			endIf
		elseif(option == id12) ;hostilevigilfaction
			if playerref.IsInFaction(_s.SuH_Vigilhostile)
				playerref.RemoveFromFaction(_s.SuH_Vigilhostile)
				SetToggleOptionValue(id12, False) ;hostilevigilfaction
			else
				playerref.AddToFaction(_s.SuH_Vigilhostile)
				SetToggleOptionValue(id12, True) ;hostilevigilfaction
			endIf
			
		elseif(option == id13) ;status.endactonatk
			if _s.SuH_SETactendonatk > 0
				_s.SuH_SETactendonatk = 0
				SetToggleOptionValue(id13, FALSE) ;status.endactonatk
			else
				_s.SuH_SETactendonatk = 1
				SetToggleOptionValue(id13, TRUE) ;status.endactonatk
			endIf
			
		elseif(option == id14) ;status.clearactor
			if _s.SuH_SETclearactor > 0
				_s.SuH_SETclearactor = 0
				SetToggleOptionValue(id14, FALSE) ;status.clearactor
			else
				_s.SuH_SETclearactor = 1
				SetToggleOptionValue(id14, TRUE) ;status.clearactor
			endIf
			
		elseif(option == id15) ;status.malehomo
			if _s.SuH_SETallowmalehomo > 0
				_s.SuH_SETallowmalehomo = 0
				SetToggleOptionValue(id15, FALSE) ;status.malehomo
			else
				_s.SuH_SETallowmalehomo = 1
				SetToggleOptionValue(id15, TRUE) ;status.malehomo
			endIf
			
		elseif(option == id16) ;status.femalehomo
			if _s.SuH_SETallowfemalehomo > 0
				_s.SuH_SETallowfemalehomo = 0
				SetToggleOptionValue(id16, FALSE) ;status.femalehomo
			else
				_s.SuH_SETallowfemalehomo = 1
				SetToggleOptionValue(id16, TRUE) ;status.femalehomo
			endIf
			
		elseif(option == id17) ;status.restricact
			if _s.SuH_SETrestrictact > 0
				_s.SuH_SETrestrictact = 0
				SetToggleOptionValue(id17, FALSE) ;status.restricact
			else
				_s.SuH_SETrestrictact = 1
				SetToggleOptionValue(id17, TRUE) ;status.restricact
			endIf
			
		elseif(option == id19) ;status.petspells
			if playerref.HasSpell(_s.SuH_spell_petself)
				playerref.RemoveSpell(_s.SuH_spell_petself)
				playerref.RemoveSpell(_s.SuH_spell_pettarget)
				SetToggleOptionValue(id19, FALSE) ;status.petspells
			else
				playerref.AddSpell(_s.SuH_spell_petself)
				playerref.AddSpell(_s.SuH_spell_pettarget)
				SetToggleOptionValue(id19, TRUE) ;status.petspells
			endIf
			
		elseif(option == id20) ;status.removepet
			if _s.SuH_SETpetremoveondeath > 0
				_s.SuH_SETpetremoveondeath = 0
				SetToggleOptionValue(id20, FALSE) ;status.removepet
			else
				_s.SuH_SETpetremoveondeath = 1
				SetToggleOptionValue(id20, TRUE) ;status.removepet
			endIf
			
		elseif(option == id3) ;status.dismisspet
			if _s.SuH_SETpetnewsumdismiss > 0
				_s.SuH_SETpetnewsumdismiss = 0
				SetToggleOptionValue(id3, FALSE) ;status.dismisspet
			else
				_s.SuH_SETpetnewsumdismiss = 1
				SetToggleOptionValue(id3, TRUE) ;status.dismisspet
			endIf
			
		elseif(option == id9) ;status.petstayfollowing
			if _s.SuH_SETpetstayfollowing > 0
				_s.SuH_SETpetstayfollowing = 0
				SetToggleOptionValue(id9, FALSE) ;status.dismisspet
			else
				_s.SuH_SETpetstayfollowing = 1
				SetToggleOptionValue(id9, TRUE) ;status.dismisspet
			endIf
			
		elseif(option == id21) ;status.combatseduction
			if _s.SuH_SETcombatseduction > 0
				_s.SuH_SETcombatseduction = 0
				SetToggleOptionValue(id21, FALSE) ;status.combatseduction
			else
				_s.SuH_SETcombatseduction = 1
				SetToggleOptionValue(id21, TRUE) ;status.combatseduction
			endIf
			
		elseif(option == id30) ;status.dom
			if _s.SuH_SETspecialdeath > 0
				_s.PlayerBase.SetEssential(False)
				;playerref.SetNoBleedoutRecovery(True)
				_s.SuH_SETspecialdeath = 0
				SetToggleOptionValue(id30, FALSE) ;status.dom
			else
				_s.PlayerBase.SetEssential(True)
				_s.SuH_SETspecialdeath = 1
				SetToggleOptionValue(id30, TRUE) ;status.dom
			endIf
			
		elseif(option == id32) ;status.loseitems
			if _s.SuH_SETsdloseitems > 0
				_s.SuH_SETsdloseitems = 0
				SetToggleOptionValue(id32, FALSE) ;status.loseitems
			else
				_s.SuH_SETsdloseitems = 1
				SetToggleOptionValue(id32, TRUE) ;status.loseitems
			endIf
			
		elseif(option == id33) ;status.losegold
			if _s.SuH_SETsdlosegold > 0
				_s.SuH_SETsdlosegold = 0
				SetToggleOptionValue(id33, FALSE) ;status.losegold
			else
				_s.SuH_SETsdlosegold = 1
				SetToggleOptionValue(id33, TRUE) ;status.losegold
			endIf
			
		elseif(option == id34) ;status.losebloodchips
			if _s.SuH_SETsdlosebloodchips > 0
				_s.SuH_SETsdlosebloodchips = 0
				SetToggleOptionValue(id34, FALSE) ;status.losebloodchips
			else
				_s.SuH_SETsdlosebloodchips = 1
				SetToggleOptionValue(id34, TRUE) ;status.losebloodchips
			endIf
			
		elseif(option == id35) ;status.loseequip
			if _s.SuH_SETsdloseequip > 0
				_s.SuH_SETsdloseequip = 0
				SetToggleOptionValue(id35, FALSE) ;status.loseequip
			else
				_s.SuH_SETsdloseequip = 1
				SetToggleOptionValue(id35, TRUE) ;status.loseequip
			endIf
			
		elseif(option == id38) ;status.neverdie
			if _s.SuH_SETneverdiemode > 0
				_s.SuH_SETneverdiemode = 0
				SetToggleOptionValue(id38, FALSE) ;status.neverdie
			else
				_s.SuH_SETneverdiemode = 1
				SetToggleOptionValue(id38, TRUE) ;status.neverdie
			endIf
		elseif(option == id39) ;status.SuH_SETmilkdistribute
			if _s.SuH_SETmilkdistribute > 0
				_s.SuH_SETmilkdistribute = 0
				SetToggleOptionValue(option, FALSE) ;settings.SuH_SETmilkdistribute
			else
				_s.SuH_SETmilkdistribute = 1
				SetToggleOptionValue(option, TRUE) ;settings.SuH_SETmilkdistribute
			endIf
		elseif(option == id40) ;status.SuH_SETdynaspid
			if _s.SuH_SETdynaspid > 0
				_s.SuH_SETdynaspid = 0
				SetToggleOptionValue(option, FALSE) ;settings.SuH_SETmilkdistribute
			else
				_s.SuH_SETdynaspid = 1
				SetToggleOptionValue(option, TRUE) ;settings.SuH_SETmilkdistribute
			endIf
		elseif(option == id41) ;status.SuH_SETspermdistribute
			if _s.SuH_SETspermdistribute > 0
				_s.SuH_SETspermdistribute = 0
				SetToggleOptionValue(option, FALSE) ;settings.SuH_SETmilkdistribute
			else
				_s.SuH_SETspermdistribute = 1
				SetToggleOptionValue(option, TRUE) ;settings.SuH_SETmilkdistribute
			endIf
		elseif(option == id11) ;_s.SuH_SETtraitwontkill
			if _s.SuH_SETtraitwontkill > 0
				_s.SuH_SETtraitwontkill = 0
				SetToggleOptionValue(option, FALSE) ;SuH_SETtraitwontkill
			else
				_s.SuH_SETtraitwontkill = 1
				SetToggleOptionValue(option, TRUE) ;SuH_SETtraitwontkill
			endIf
		elseif(option == id42) ;_s.SuH_SETdrainvisualinact
			if _s.SuH_SETdrainvisualinact > 0
				_s.SuH_SETdrainvisualinact = 0
				SetToggleOptionValue(option, FALSE) ;SuH_SETdrainvisualinact
			else
				_s.SuH_SETdrainvisualinact = 1
				SetToggleOptionValue(option, TRUE) ;SuH_SETdrainvisualinact
			endIf
		elseif(option == id44) ;_s.SuH_SETpreventactdeath
			if _s.SuH_SETpreventactdeath > 0
				_s.SuH_SETpreventactdeath = 0
				SetToggleOptionValue(option, FALSE) ;SuH_SETpreventactdeath
			else
				_s.SuH_SETpreventactdeath = 1
				SetToggleOptionValue(option, TRUE) ;SuH_SETpreventactdeath
			endIf
		endIf
	endIf
endEvent
Event OnOptionMenuOpen(int option)
	if CurrentPage == "Soul Pets"
		if option == id15
			string[] menuoptions = new string[4]
			menuoptions[0] = "Cancel / Don't Remove Any Trait"
			menuoptions[1] = _f.PetGetTraitName(_s.SuH_pettrait0[petselectedslot])
			menuoptions[2] = _f.PetGetTraitName(_s.SuH_pettrait1[petselectedslot])
			menuoptions[3] = _f.PetGetTraitName(_s.SuH_pettrait2[petselectedslot])
			SetMenuDialogOptions(menuoptions)
			SetMenuDialogStartIndex(0)
			SetMenuDialogDefaultIndex(0)
		endIf
	elseif CurrentPage == "Settings"
		if option == id1 ;setnpcabsorb
			string[] menuoptions = new string[4]
			menuoptions[0] = "No NPCs"
			menuoptions[1] = "All NPCs"
			menuoptions[2] = "Non-Allies"
			menuoptions[3] = "Hostile Only"
			SetMenuDialogOptions(menuoptions)
			SetMenuDialogStartIndex(_s.SuH_SETnpcabsorb)
			SetMenuDialogDefaultIndex(1)
		elseif option == id4 ;drainkill
			string[] menuoptions = new string[4]
			menuoptions[0] = "Never"
			menuoptions[1] = "Always"
			menuoptions[2] = "Non-Allies"
			menuoptions[3] = "Hostile Only"
			SetMenuDialogOptions(menuoptions)
			SetMenuDialogStartIndex(_s.SuH_SETallowdrainkill)
			SetMenuDialogDefaultIndex(1)
		elseif option == id31
			string[] menuoptions = new string[3]
			menuoptions[0] = "Disabled"
			menuoptions[1] = "Random Location"
			menuoptions[2] = "Last Entrance (Default)"
			SetMenuDialogOptions(menuoptions)
			SetMenuDialogStartIndex(_s.SuH_SETrandomdeathspawn)
			SetMenuDialogDefaultIndex(2)
		endIf
	endIf
endEvent
Event OnOptionMenuAccept(int option, int index)
	if CurrentPage == "Soul Pets"
		if option == id15
			if index == 0
				; Cancelled, do nothing
			else
				if PlayerRef.GetItemCount(_s.SuH_misc_bloodchip) < 30
					Debug.MessageBox(": Soul Pets :\nNot Enough Blood Chips\nRequires 30 Blood Chips to remove a Pet Trait")
				elseif index == 1 ; Slot 0
					if _s.SuH_pettrait0[petselectedslot] > 0 ; if has trait, remove slot and collapse traits, change MCM display
						PlayerRef.RemoveItem(_s.SuH_misc_bloodchip, 30) ; remove blood chip cost
						string pettraitname = _f.PetGetTraitName(_s.SuH_pettrait0[petselectedslot])
						_s.SuH_pettrait0[petselectedslot] = _s.SuH_pettrait1[petselectedslot]
						if _s.SuH_pettrait0[petselectedslot] > 0
							SetTextOptionValue(id12, _f.PetGetTraitName(_s.SuH_pettrait0[petselectedslot]))
						else
							SetTextOptionValue(id12, " - - - ")
						endIf
						_s.SuH_pettrait1[petselectedslot] = _s.SuH_pettrait2[petselectedslot]
						if _s.SuH_pettrait1[petselectedslot] > 0
							SetTextOptionValue(id13, _f.PetGetTraitName(_s.SuH_pettrait1[petselectedslot]))
						else
							SetTextOptionValue(id13, " - - - ")
						endIf
						_s.SuH_pettrait2[petselectedslot] = 0
						SetTextOptionValue(id14, " - - - ")
						_f.PetReapplyTraits(petselectedslot)
						Debug.MessageBox(": Soul Pets :\nPet Trait "+pettraitname+" Removed.\n30 Blood Chips Removed")
					endIf
				elseif index == 2 ; Slot 1
					if _s.SuH_pettrait1[petselectedslot] > 0 ; if has trait, remove slot and collapse traits, change MCM display
						PlayerRef.RemoveItem(_s.SuH_misc_bloodchip, 30) ; remove blood chip cost
						string pettraitname = _f.PetGetTraitName(_s.SuH_pettrait1[petselectedslot])
						_s.SuH_pettrait1[petselectedslot] = _s.SuH_pettrait2[petselectedslot]
						if _s.SuH_pettrait1[petselectedslot] > 0
							SetTextOptionValue(id13, _f.PetGetTraitName(_s.SuH_pettrait1[petselectedslot]))
						else
							SetTextOptionValue(id13, " - - - ")
						endIf
						_s.SuH_pettrait2[petselectedslot] = 0
						SetTextOptionValue(id14, " - - - ")
						_f.PetReapplyTraits(petselectedslot)
						Debug.MessageBox(": Soul Pets :\nPet Trait "+pettraitname+" Removed.\n30 Blood Chips Removed")
					endIf
				elseif index == 3 ; Slot 0
					if _s.SuH_pettrait2[petselectedslot] > 0 ; if has trait, remove slot and collapse traits, change MCM display
						PlayerRef.RemoveItem(_s.SuH_misc_bloodchip, 30) ; remove blood chip cost
						string pettraitname = _f.PetGetTraitName(_s.SuH_pettrait2[petselectedslot])
						_s.SuH_pettrait2[petselectedslot] = 0
						SetTextOptionValue(id14, " - - - ")
						_f.PetReapplyTraits(petselectedslot)
						Debug.MessageBox(": Soul Pets :\nPet Trait "+pettraitname+" Removed.\n30 Blood Chips Removed")
					endIf
				endIf
			endIf
		endIf
	elseif CurrentPage == "Settings"
		if option == id1 ;setnpcabsorb
			if index == 0
				_s.SuH_SETnpcabsorb = 0
				SetMenuOptionValue(id1, "No NPCs")
			elseif index == 1
				_s.SuH_SETnpcabsorb = 1
				SetMenuOptionValue(id1, "All NPCs")
			elseif index == 2
				_s.SuH_SETnpcabsorb = 2
				SetMenuOptionValue(id1, "Non-Allies")
			elseif index == 3
				_s.SuH_SETnpcabsorb = 3
				SetMenuOptionValue(id1, "Hostile Only")
			endIf
		elseif option == id4 ;drainkill
			if index == 0
				_s.SuH_SETallowdrainkill = 0
				SetMenuOptionValue(id4, "Never")
			elseif index == 1
				_s.SuH_SETallowdrainkill = 1
				SetMenuOptionValue(id4, "Always")
			elseif index == 2
				_s.SuH_SETallowdrainkill = 2
				SetMenuOptionValue(id4, "Non-Allies")
			elseif index == 3
				_s.SuH_SETallowdrainkill = 3
				SetMenuOptionValue(id4, "Hostile Only")
			endIf
		elseif option == id31
			if index == 0
				_s.SuH_SETrandomdeathspawn = 0
				SetMenuOptionValue(id31, "Disabled")
			elseif index == 1
				_s.SuH_SETrandomdeathspawn = 1
				SetMenuOptionValue(id31, "Random Location")
			elseif index == 2
				_s.SuH_SETrandomdeathspawn = 2
				SetMenuOptionValue(id31, "Last Entrance")
			endIf
		endIf
	endIf
endEvent
Event OnOptionSliderOpen(int option)
	if(CurrentPage == "Status")
		If(option == id21) ;SuH_SETcarrycorrect
			SetSliderDialogStartValue(0)
			SetSliderDialogDefaultValue(0)
			SetSliderDialogRange(0, (Math.Floor((((playerref.GetLevel() - 1) * 5)))) )
			SetSliderDialogInterval(1)
		endIf
	elseif(CurrentPage == "Skill Levels") ; Skill Levels
		If(option == id3) ;xptoskillxp
			SetSliderDialogStartValue(0)
			SetSliderDialogDefaultValue(0)
			SetSliderDialogRange(0, (Math.Floor(_s.SuH_PCSxp * 0.1) * 10) )
			SetSliderDialogInterval(10)
		endIf
	elseIf(CurrentPage == "Settings") ; Settings
		If(option == id0) ;effectmulti
			SetSliderDialogStartValue(_s.SuH_PCSeffectmulti * 100.0)
			SetSliderDialogDefaultValue(100)
			SetSliderDialogRange(0,1000)
			SetSliderDialogInterval(1)
			
		elseIf(option == id10) ;SuH_PCSarousalgainmulti
			SetSliderDialogStartValue(_s.SuH_PCSarousalgainmulti * 100)
			SetSliderDialogDefaultValue(100)
			SetSliderDialogRange(0,1000)
			SetSliderDialogInterval(1)
		
		elseIf(option == id22) ;status.cscooldown
			SetSliderDialogStartValue(_s.SuH_SETcscooldown)
			SetSliderDialogDefaultValue(10)
			SetSliderDialogRange(0,1800)
			SetSliderDialogInterval(1)
			
		elseIf(option == id23) ;status.pctonpchealth
			SetSliderDialogStartValue(_s.SuH_SETpc2npchealth*100)
			SetSliderDialogDefaultValue(30)
			SetSliderDialogRange(0,100)
			SetSliderDialogInterval(1)
			
		elseIf(option == id24) ;status.pctonpchealthmin
			SetSliderDialogStartValue(_s.SuH_SETpc2npchealthmin)
			SetSliderDialogDefaultValue(20)
			SetSliderDialogRange(0,100000)
			SetSliderDialogInterval(1)
			
		elseIf(option == id25) ;status.pctonpcstamina
			SetSliderDialogStartValue(_s.SuH_SETpc2npcstamina*100)
			SetSliderDialogDefaultValue(30)
			SetSliderDialogRange(0,100)
			SetSliderDialogInterval(1)
			
		elseif(option == id26) ;status.npctopchealth
			SetSliderDialogStartValue(_s.SuH_SETnpc2pchealth*100)
			SetSliderDialogDefaultValue(30)
			SetSliderDialogRange(0,100)
			SetSliderDialogInterval(1)
			
		elseif(option == id27) ;status.npctolchealthmin
			SetSliderDialogStartValue(_s.SuH_SETnpc2pchealthmin)
			SetSliderDialogDefaultValue(20)
			SetSliderDialogRange(0,100000)
			SetSliderDialogInterval(1)
			
		elseIf(option == id28) ;status.npctonpchealth
			SetSliderDialogStartValue(_s.SuH_SETnpc2npchealth*100)
			SetSliderDialogDefaultValue(30)
			SetSliderDialogRange(0,100)
			SetSliderDialogInterval(1)
			
		elseIf(option == id29) ;status.npctonpchealthmin
			SetSliderDialogStartValue(_s.SuH_SETnpc2npchealthmin)
			SetSliderDialogDefaultValue(20)
			SetSliderDialogRange(0,100000)
			SetSliderDialogInterval(1)
		elseIf(option == id36) ;status.SETrevivecost
			SetSliderDialogStartValue(_s.SuH_SETrevivecost)
			SetSliderDialogDefaultValue(0)
			SetSliderDialogRange(0,100)
			SetSliderDialogInterval(1)
		elseIf(option == id37) ;status.csbleedoutdelay
			SetSliderDialogStartValue(_s.SuH_SETcsbleedoutdelay)
			SetSliderDialogDefaultValue(5)
			SetSliderDialogRange(0,20)
			SetSliderDialogInterval(1.0)
		endIf
	endIf
endEvent
Event OnOptionSliderAccept(int option, float value)
	if(CurrentPage == "Status")
		if(option == id21) ;SuH_SETcarrycorrect
			_s.SuH_SETcarrycorrect = Math.Floor(value)
			playerref.SetActorValue("carryweight", (value + 300))
			SetSliderOptionValue(option, value, "{0}") ;status.pctonpchealthmin
		endIf
	elseif(CurrentPage == "Skill Levels")
		if(option == id3) ;skill.convert
			_s.SuH_PCSxp -= Math.Floor(value)
			_s.SuH_PCSskillxp += Math.Floor(value/10)
			debug.MessageBox("Converted "+(Math.Floor(value))+"HeartXP into "+(Math.Floor((value/10)))+"SkillXP")
			ForcePageReset()
		endIf
	elseIf(CurrentPage == "Settings") ; Settings
		
		if(option == id0) ;effectmulti
			_s.SuH_PCSeffectmulti = (value/100)
			SetSliderOptionValue(id0, value, "{0}%") ;effectmulti
		elseif(option == id10) ;SuH_PCSarousalgainmulti
			_s.SuH_PCSarousalgainmulti = (value/100)
			SetSliderOptionValue(id10, value, "{0}%") ; settings.desiregain
			
		elseif(option == id22) ;status.cscooldown
			_s.SuH_SETcscooldown = Math.Floor(value)
			SetSliderOptionValue(id22, value, "{0} Seconds")
		
		elseif(option == id23) ;status.pctonpchealth
			_s.SuH_SETpc2npchealth = (value/100)
			SetSliderOptionValue(id23, value, "{0}% Health") ;status.pctonpchealth
			
		elseif(option == id24) ;status.pctonpchealthmin
			_s.SuH_SETpc2npchealthmin = Math.Floor(value)
			SetSliderOptionValue(id24, value, "{0} Health") ;status.pctonpchealthmin
			
		elseif(option == id25) ;status.pctonpcstamina
			_s.SuH_SETpc2npcstamina = (value/100)
			SetSliderOptionValue(id25, value, "{0}% Stamina") ;status.pctonpcstamina
			
		elseif(option == id26) ;status.npctopchealth
			_s.SuH_SETnpc2pchealth = (value/100)
			SetSliderOptionValue(id26, value, "{0}% Health") ;status.npctopchealth
			
		elseif(option == id27) ;status.npctolchealthmin
			_s.SuH_SETnpc2pchealthmin = Math.Floor(value)
			SetSliderOptionValue(id27, value, "{0} Health") ;status.npctolchealthmin
			
		elseif(option == id28) ;status.npctonpchealth
			_s.SuH_SETnpc2npchealth = (value/100)
			SetSliderOptionValue(id28, value, "{0}% Health") ;status.npctonpchealth
			
		elseif(option == id29) ;status.npctonpchealthmin
			_s.SuH_SETnpc2npchealthmin = Math.Floor(value)
			SetSliderOptionValue(id29, value, "{0} Health") ;status.npctonpchealthmin
			
		elseif(option == id36) ;status.SETrevivecost
			_s.SuH_SETrevivecost = (value/100)
			SetSliderOptionValue(id36, value, "{0}% Status Cap") ;status.SETrevivecost
			
		elseif(option == id37) ;status.csbleedoutdelay
			_s.SuH_SETcsbleedoutdelay = Math.Floor(value)
			SetSliderOptionValue(id37, value, "{0} Sec") ;status.csbleedoutdelay
		endIf
	endIf
endEvent
Event OnOptionInputOpen(int option)
	if CurrentPage == "Soul Pets"
		if(option == id8) ; rename pet
			SetInputDialogStartText(_s.SuH_petnames[petselectedslot])
		endIf
	endIf
endEvent
Event OnOptionInputAccept(int option, string isnotavariablemyfuckingasspapyrusshutup)
	if CurrentPage == "Soul Pets"
		if(option == id8) ; rename pet
			if isnotavariablemyfuckingasspapyrusshutup != ""
				_s.SuH_petnames[petselectedslot] = ""
				string petname = isnotavariablemyfuckingasspapyrusshutup
				int i = 0
				int x = 0
				while i < _s.SuH_petnames.length
					if petname == _s.SuH_petnames[i]
						x += 1
						petname = isnotavariablemyfuckingasspapyrusshutup+x
						i = 0
					else
						i += 1
					endIf
				endwhile
				_s.SuH_petnames[petselectedslot] = petname
				ForcePageReset() ; Reset page to update names in pet slots correctly
			endIf
		endIf
	endIf
endEvent
Event OnOptionKeyMapChange(int option, int keyCode, string conflictControl, string conflictName) ; OnOptionKeyMapChange
	if (CurrentPage == "Status")
		if (option == id8) ; Set SuH_KEY_draintoggle
			if (keyCode == 1)
				_s.SuH_KEY_draintoggle = -1
				_f.registerforkeybind()
				SetKeyMapOptionValue(option, -1)
			else
				_s.SuH_KEY_draintoggle = KeyCode
				_f.registerforkeybind()
				SetKeyMapOptionValue(option, keyCode)
			endIf
		elseif (option == id20) ; Set SuH_KEY_drainkilltoggle
			if (keyCode == 1)
				_s.SuH_KEY_drainkilltoggle = -1
				_f.registerforkeybind()
				SetKeyMapOptionValue(option, -1)
			else
				_s.SuH_KEY_drainkilltoggle = KeyCode
				_f.registerforkeybind()
				SetKeyMapOptionValue(option, keyCode)
			endIf
		elseif (option == id12) ; Set SuH_KEY_arousalview
			if (keyCode == 1)
				_s.SuH_KEY_arousalview = -1
				_f.registerforkeybind()
				SetKeyMapOptionValue(option, -1)
			else
				_s.SuH_KEY_arousalview = KeyCode
				_f.registerforkeybind()
				SetKeyMapOptionValue(option, keyCode)
			endIf
		elseif (option == id13) ; Set SuH_KEY_petself
			if (keyCode == 1)
				_s.SuH_KEY_petself = -1
				_f.registerforkeybind()
				SetKeyMapOptionValue(option, -1)
			else
				_s.SuH_KEY_petself = KeyCode
				_f.registerforkeybind()
				SetKeyMapOptionValue(option, keyCode)
			endIf
		endIf
	endIf
endEvent
Event OnOptionHighlight(int option)
	if(CurrentPage == "Initiate") ; Initiate
	
		if(option == id0) ; Initiate
			SetInfoText("Start Succubus Heart. Once Succubus Heart has started it can not be disabled and will make permanent changes to your save! Make sure to back-up your save! [After selecting initiate you'll need to exit the MCM to finish the start-up process]")
		endIf
	
	elseif(CurrentPage == "Status") ; Status
	
		if(option == id0) ; healthcap
			SetInfoText("Current Max Health / Effective Health Cap (Total Health Cap) [Max is your current Max Health, Cap is how high absorption can make your Max Health] [Shows Effective Cap, the highest Effective Cap is based on Player Level]")
		elseif(option == id1) ; magickacap
			SetInfoText("Current Max Magicka / Effective Magicka Cap (Total Magicka Cap) [Max is your current Max Magicka, Cap is how high absorption can make your Max Magicka] [Shows Effective Cap, the highest Effective Cap is based on Player Level]")
		elseif(option == id2) ; staminacap
			SetInfoText("Current Max Stamina / Effective Stamina Cap (Total Stamina Cap) [Max is your current Max Stamina, Cap is how high absorption can make your Max Stamina] [Shows Effective Cap, the highest Effective Cap is based on Player Level]")
		elseif(option == id19) ; SuH_PCScaplevel
			SetInfoText("Effective Cap [Effective Cap is determined by player level, scaling can be improved with Heart Levels]")
			
		elseif(option == id3) ; sexbonus
			SetInfoText("Sex Bonus Time remaining, using in-game time. [Build up Sex Bonus Time while in sex acts, decays while not in a sex act]")
		elseif(option == id4); fluidbonus
			SetInfoText("Sexual Fluid Bonus Time remaining, using in-game time. [Build up Fluid Bonus when consuming Sperm / Milk]")
			
		elseif(option == id15); healthabsorprating
			SetInfoText("Health Absorption Rating determines how much Max Health is drained from partners in sex acts. [Drain starts at the determined value then decays to ~80% as the act goes on. For example, with 10 Absorbtion Rating the drained amount will be 10,8,7,6,5,4,3,3,2,2,2,1,1,1,0]")
		elseif(option == id16); 
			SetInfoText("Magicka Absorption Rating determines how much Max Magicka is drained from partners in sex acts. [Drain starts at the determined value then decays to ~80% as the act goes on. For example, with 10 Absorbtion Rating the drained amount will be 10,8,7,6,5,4,3,3,2,2,2,1,1,1,0]")
		elseif(option == id17); 
			SetInfoText("Stamina Absorption Rating determines how much Max Stamina is drained from partners in sex acts. [Drain starts at the determined value then decays to ~80% as the act goes on. For example, with 10 Absorbtion Rating the drained amount will be 10,8,7,6,5,4,3,3,2,2,2,1,1,1,0]")
			
		elseif(option == id18); 
			SetInfoText("BDSM Ratings. These values are used to enhance the effect of various Passives and Actives. [Increase BDSM Rating by spending HeartXP to improve Heart Levels]")
		
		elseif(option == id9) ; Lust
			SetInfoText("Current Lust [Orgasms reduce Lust, High Lust grants bonus HeartXP but comes with side effects. While in a low Lust State Sexual Fluids will increase lust, while in a high Lust State Sexual Fluids will decrease Lust] [Uses In-Game Time]")
		elseif(option == id11) ; Lust State
			int x = _s.SuH_PCSarousalstate
			if x == 0
				SetInfoText("Current Lust State : Feeling Exhausted [Very Low Lust - Sex Drain starts at 50%]")
			elseif x == 1
				SetInfoText("Current Lust State : Feeling Normal [Tolerable Lust Levels - No negative effect]")
			elseif x == 2
				SetInfoText("Current Lust State : Having some Cravings [High Lust Levels - Max Health/Magicka/Stamina slowly decays, 1per 60seconds]")
			elseif x == 3
				SetInfoText("Current Lust State : Experiencing Withdrawl [Excessive Lust Levels - Max Health/Magicka/Stamina slowly decays, 1per 30seconds, giving off dangerous pheromones...]")
			elseif x == 4
				SetInfoText("Current Lust State : Feeling Faint [Dangerous Lust Levels - Max Health/Magicka/Stamiona slowly decays, 1per 20seconds, irregularly take Status damage, giving off dangerous pheromones...]")
			endIf
		elseif(option == id30) ;status.xp
			SetInfoText("Current amount of HeartXP Available. [Gain HeartXP through Sex Acts, Items, or Passives]")
		elseif(option == id31) ;status.xpgain
			SetInfoText("Current base HeartXP Gain rate, increasing HeartXP earned by a percentage [Excludes situational bonuses such as from Passives or Lust benefits]")
		elseif(option == id32) ;status.version
			SetInfoText("Raw mod version number grabbed from SuH_Status. If you have issues, including this number with your bug/issue report can help.")
		elseif(option == id22) ;status.Framework
			SetInfoText("Which Sex Framework to prefer when getting stats or starting animations, SexLab is highly recommended. Including this with your bug/issue report can help. [Check the 'Only Use Framework Pref.' in settings for further settings]")
			
		elseif(option == id21) ;SuH_SETcarrycorrect
			SetInfoText("This option allows 'correcting' carry weight. By default leveling Stamina increases Carry Weight by 5, however Health and Magicka do not. Increase this value by 5 for each level you selected Health or Magicka to have carry weight equal what it would be if you only selected Stamina, getting 5 carry weight per level. [Default : 0]")
		elseif(option == id33) ;statusdisablehealthrec
			SetInfoText("While Enabled : Disable player's base Health Regeneration [Addative regen buffs/items will still work] [When disabling, save then reload for changes to take affect] [Default : Disabled]")
		elseif(option == id34) ;statusdisablemagickarec
			SetInfoText("While Enabled : Disable player's base Magicka Regeneration [Addative regen buffs/items will still work] [When disabling, save then reload for changes to take affect] [Default : Disabled]")
		elseif(option == id35) ;statusdisablestaminarec
			SetInfoText("While Enabled : Disable player's base Stamina Regeneration [Addative regen buffs/items will still work] [When disabling, save then reload for changes to take affect] [Default : Disabled]")
			
		elseif(option == id10) ;SuH_PCSgender
			SetInfoText("Detected Player Gender [Detected from SexLab]")
		elseif(option == id14) ;playerlevel
			SetInfoText("Current Player Level")
			
		elseif(option == id8) ; Set SuH_KEY_draintoggle
			SetInfoText("Hotkey : Toggles 'Drain Affects NPC Status' option [Select ESC to remove binding]")
		elseif(option == id20) ; Set SuH_KEY_drainkilltoggle
			SetInfoText("Hotkey : Toggles 'Allow Drain to Kill' option [Select ESC to remove binding]")
		elseif(option == id12) ; Set SuH_KEY_arousalview
			SetInfoText("Hotkey : Displays a notification with your Succubus' Current Lust Status [Select ESC to remove binding]")
		elseif(option == id13) ; Set SuH_KEY_petself
			SetInfoText("Hotkey : Opens pet summoning menu without having to use the Pet Self spell [Select ESC to remove binding]")
		endIf
		
	;ent/ Heart Levels
	elseif(CurrentPage == "Heart Levels")
		if(option == id0) ;heart.xp
			SetInfoText("HeartXP available to spend on abilities. [Gain HeartXP through Sex Acts, Items, or Passives]")
		elseif(option == id17)
			SetInfoText("Raw Body, Desire, Mind, and Soul Values used by passives. [Increase BDSM Rating by spending HeartXP to improve Heart Levels]")
		elseif(option == id1) ;heart.healthcap
			SetInfoText("+1 Health Cap [+ 1 Body Rating] [Health Cap determines how high absorption can make your Max Health]")
		elseif(option == id2) ;heart.magickacap
			SetInfoText("+1 Magicka Cap [+ 1 Mind Rating] [Magicka Cap determines how high absorption can make your Max Magicka]")
		elseif(option == id3) ;heart.staminacap
			SetInfoText("+1 Stamina Cap [+ 1 Soul Rating] [Stamina Cap determines how high absorption can make your Max Stamina]")
		elseif(option == id6) ;SuH_PCScaplevel
			SetInfoText("+1 Effective Cap Scaling per Player Level [+2 Body/Soul/Mind Rating] [Effective Cap determines how high your usable Status Caps can be]")
			
		elseif(option == id4) ;SuH_PCSsexbonusmax
			SetInfoText("+10% Max Sex Bonus Time [+ 5 Desire Rating] [Sex Bonus adds additional benefits to Passive and Actives while active]  [Uses in-game time]")
		elseif(option == id5) ;SuH_PCSfluidbonus
			SetInfoText("+10% Max Fluid Bonus Time [+ 5 Desire Rating] [Fluid Bonus adds additional benefits to Passive and Actives while active]  [Uses in-game time]")
			
		elseif(option == id7) ;heart.xpgain
			SetInfoText("+2% HeartXP Gain. [+10 Desire Rating] [Increases HeartXP earned by a percentage]")
			
		elseif(option == id8) ;heart.absorbhealth
			SetInfoText("+1 Health Absorption Rating [+5 Body Rating] [Health Absorption Rating increases how much Health is absorbed in Sex Acts]")
		elseif(option == id9) ;heart.absorbmagicka
			SetInfoText("+1 Magicka Absorption Rating [+5 Mind Rating] [Magicka Absorption Rating increases how much Magicka is absorbed in Sex Acts]")
		elseif(option == id10) ;heart.absorbstamina
			SetInfoText("+1 Stamina Absorption Rating [+5 Soul Rating] [Stamina Absorption Rating increases how much Stamina is absorbed in Sex Acts]")
			
		elseif(option == id11) ;SuH_PCSfluidhealth
			SetInfoText("+1 Fluid Health Bonus [+4 Body Rating] [Increases Max Health and Healing from consuming Sperm and Breast Milk]")
		elseif(option == id12) ;SuH_PCSfluidmagicka
			SetInfoText("+1 Fluid Magicka Bonus [+4 Mind Rating] [Increases Max Magicka and Magicka recovered by consuming Sperm and Breast Milk]")
		elseif(option == id13) ;SuH_PCSfluidstamina
			SetInfoText("+1 Fluid Stamina Bonus [+4 Soul Rating] [Increases Max Stamina and Stamina recovered by consuming Sperm and Breast Milk]")
		endIf
		
	elseif(CurrentPage == "Skill Levels") ;	Skill Levels [Need rewriting with the re-work]
		if(option == id0) ;skillsp
			SetInfoText("SkillXP Available to spend on increasing Skills. [Gain SkillXP through various Succubus Heart activities, such as draining beyond the Status Cap or letting Lust decay Max Status]")
		elseif(option == id2) ;skill.xp
			SetInfoText("Current HeartXP Available. [Can be converted to SKillXP at a 10 to 1 ratio]")
		elseif(option == id3) ;skill.convert
			SetInfoText("Convert HeartXP to SkillXP at a 10 to 1 ratio. [ex. 100 XP will give 10 SkillXP]")
		elseif(option == id4) ;skill.alchemy
			SetInfoText("Increase Alchemy Experience")
		elseif(option == id13) ;skill.alteration
			SetInfoText("Increase Alteration Experience")
		elseif(option == id5) ;skill.block
			SetInfoText("Increase Block Experience")
		elseif(option == id14) ;skill.conjuration
			SetInfoText("Increase Conjuration Experience")
		elseif(option == id6) ;skill.destruction
			SetInfoText("Increase Destruction Experience")
		elseif(option == id15) ;skill.enchanting
			SetInfoText("Increase Enchanting Experience")
		elseif(option == id7) ;skill.heavyarmor
			SetInfoText("Increase Heavy Armor Experience")
		elseif(option == id16) ;skill.illusion
			SetInfoText("Increase Illusion Experience")
		elseif(option == id8) ;skill.lightarmor
			SetInfoText("Increase Light Armor Experience")
		elseif(option == id17) ;skill.lockpicking
			SetInfoText("Increase Lockpicking Experience")
		elseif(option == id9) ;skill.marksman
			SetInfoText("Increase Marksman Experience")
		elseif(option == id18) ;skill.onehanded
			SetInfoText("Increase One-Handed Experience")
		elseif(option == id10) ;skill.pickpocket
			SetInfoText("Increase Pickpocket Experience")
		elseif(option == id19) ;skill.restoration
			SetInfoText("Increase Restoration Experience")
		elseif(option == id11) ;skill.smithing
			SetInfoText("Increase Smithing Experience")
		elseif(option == id20) ;skill.sneak
			SetInfoText("Increase Sneak Experience")
		elseif(option == id12) ;skill.speechcraft
			SetInfoText("Increase Speechcraft Experience")
		elseif(option == id21) ;skill.twohanded
			SetInfoText("Increase Two-Handed Experience")
		endIf
	
	
	elseif(CurrentPage == "Passives") ; Passives
	
		if(option == id0) ;spell.bdsmrating
			SetInfoText("Current Status Caps available to spend. [Status Caps can be increased with HeartXP or Soul Items]")
		elseif(option == id1) ;spell.bdsmtrue
			SetInfoText("Raw Body, Desire, Mind, and Soul Values used by passives. [Increase BDSM Rating by spending HeartXP to improve Heart Levels]")
			
		elseIf(option == id4) ;spell.masochist
			int bpoint = _s.SuH_PCSbpoint
			int r2 = _s.SuH_rank_masochist2
			int y = 0
			if r2 != 0
				y = Math.Floor(r2 * (bpoint * 0.1))
			endIf
			int x = Math.ceiling(((Math.Floor((_s.SuH_PCSbpoint * 0.01) * _s.SuH_rank_masochist3)) * (_s.SuH_PCSxpgain * 0.01)) * _s.SuH_PCSeffectmulti)
			SetInfoText("Gain "+(_s.SuH_rank_masochist)+"% Lust, recover "+y+" Stamina, and gain "+x+" HeartXP when hit. This can only trigger once every 5 seconds. [Affected by Body Rating]")
		elseIf(option == id5) ;spell.masochistrank
			SetInfoText("-15 Health Cap, Gain 1% more Lust when hit. [At least one point is required to gain Lust on-hit]")
		elseIf(option == id6) ;spell.masochistrank2
			SetInfoText("-15 Health Cap, +(10% Body) Stamina recovered when hit.")
		elseIf(option == id30) ;SuH_rank_masochist3
			SetInfoText("-30 Stamina Cap, +(1% Body) HeartXP earned when hit. [Affected by HeartXP Gain %]")
			
		elseIf(option == id7) ;spell.violence
			int spoint = _s.SuH_PCSspoint
			int r1 = _s.SuH_rank_violence
			int x = 0
			if r1 != 0
				x = Math.Floor(r1 * (spoint * 0.05))
			endif
			int r2 = _s.SuH_rank_violence2
			int y = 0
			if r2 != 0
				y = Math.Floor(r2 * (spoint * 0.05))
			endif
			int r3 = _s.SuH_rank_violence3
			int z = 0
			if r3 != 0
				z = Math.Floor(r3 * (spoint * 0.05))
			endif
			SetInfoText("When hitting an enemy absorb "+x+" Health, "+y+" Magicka, "+z+" Stamina. This effect can only happen once every 10 seconds. [Affected by Soul Rating]")
		elseIf(option == id8) ;spell.violencerank
			SetInfoText("-80 Health Cap, +(5% Soul) Health Absorbtion on hit.")
		elseIf(option == id9) ;spell.violencerank2
			SetInfoText("-80 Magicka Cap, +(5% Soul) Magicka Absorption on hit.")
		elseIf(option == id10) ;spell.violencerank3
			SetInfoText("-80 Stamina Cap, +(5% Soul) Stamina Absorption on hit.")
			
		elseIf(option == id11) ;spell.regalglow
			int r1 = _s.SuH_rank_regalglow
			int y = 0
			if r1 > 0
				y = Math.Floor(r1 * (_s.SuH_PCSmpoint * 0.05))
			endIf
			SetInfoText("Equip 'Regal Glow' when not wearing any body armor, increasing Armor Rating by "+y+". [Affected by Mind Rating and Light Armor enhancements] [May conflict with armor mods and equipment checkers]")
		elseIf(option == id12) ;spell.regalglowrank
			SetInfoText("-25 Magicka Cap, +(5% Mind) Armor Rating of Regal Glow.")
			
		elseIf(option == id13) ;spell.savingessence
			int r1 = _s.SuH_rank_savingessence
			int x = 0
			if r1 > 0
				x = Math.Floor(r1 * (_s.SuH_PCSbpoint * 0.05))
			endIf
			int y = ( 300 - (_s.SuH_rank_savingessence2 * 20) )
			SetInfoText("While Fluid Bonus is active and hit below 30% Health, restore "+x+" Health. If Health is recovered "+y+" minutes (In-Game Time) is removed from Fluid Bonus Time. [Affected by Body Rating]")
		elseIf(option == id14) ;spell.savingessencerank
			SetInfoText("-30 Health Cap, +(5% Body) Health recovery")
		elseIf(option == id15) ;spell.savingessencerank2
			SetInfoText("-30 Magicka Cap, -20min (In-Game Time) Fluid Bonus Cost")
			
		elseIf(option == id16) ;spell.seducer
			int x = (_s.SuH_rank_seducer * 10)
			int y = (_s.SuH_rank_seducer2 * 20)
			SetInfoText("Seduction Spells have a "+x+"% increased success rate and the Negative Effects of High Lust trigger "+y+"% higher than usual.")
		elseIf(option == id17) ;spell.seducerrank
			SetInfoText("-30 Health/Magicka/Stamina Cap, +10% Seduction Success Rate (Flat rate increase)")
		elseIf(option == id28) ;spell.seducerrank2
			SetInfoText("-35 Stamina Cap, +20% Lust Resistance")
			
		elseIf(option == id18) ;spell.deviouspartner
			int x = (_s.SuH_rank_deviouspartner * 20)
			int y = (_s.SuH_rank_deviouspartner2 * 10)
			int m = Math.Floor(_s.SuH_PCSdpoint * 0.4)
			SetInfoText("When your Succubus' partner is distracted by an orgasm, your Succubus has a "+x+"% chance to steal "+m+" gold (40% of Desire Rating) and a "+y+"% chance to steal a random item from them.")
		elseIf(option == id19) ;spell.deviouspartnerrank
			SetInfoText("-20 Stamina Cap, +20% Chance to steal gold")
		elseIf(option == id20) ;spell.deviouspartnerrank2
			SetInfoText("-30 Magicka Cap, +10% Chance to steal item")
			
		elseIf(option == id32) ;SuH_rank_soultap
			int x = (_s.SuH_rank_soultap * 20)
			SetInfoText("When ending a Sex Act, your Succubus has a "+x+"% chance to cast Soul Trap on each partner who isn't an ally. [Soul Trap ignores Soul Pets]")
		elseIf(option == id44) ;SuH_rank_soultap
			SetInfoText("-25 Magicka Cap, +20% Chance to cast Soul Trap on non-ally partners after a sex act.")
		elseIf(option == id45) ;SuH_rank_soultapplus
			SetInfoText("-80 Magicka Cap to unlock, while unlocked, when the player's Succubus drain kills a partner, remaining Max Status is drained by the current Fluid Bonus Levels. [Each Fluid Bonus affects the corrisponding status type, for example Fluid Magicka Bonus will drain remaining Magicka]")
			
		elseIf(option == id21) ;spell.giftedconsent
			string m = " [Applies before drain if consent drain is enabled]"
			if _s.SuH_rank_giftedconsentplus > 0
				m = "Gifted Consent+ Unlocked : Consensual partners do not lose Max Status from drain but your Succubus' benefits start at 10% of their normal drain."
			endIf
			int x = _s.SuH_rank_giftedconsent
			SetInfoText("Grants consensual parters with "+x+" Max Health/Magicka/Stamina every 5 seconds."+m)
		elseIf(option == id22) ;spell.giftedconsentrank
			SetInfoText("-10 Magicka Cap -5 Stamina Cap, +1 Max Health/Magicka/Stamina granted to partner every 5 seconds")
		elseIf(option == id31) ;spell.giftedconsentrankplus
			SetInfoText("-40 Health/Magicka/Stamina Cap to unlock, While unlocked consensual partners do not lose Max Status from drain but your Succubus' benefits start at 10% of their normal drain.")
			
		elseif(option == id2) ;spell.xp
			SetInfoText("Spend HeartXP for +5 Body/Desire/Soul/Mind Rating (+20 total BDSM Rating).")
		elseif(option == id3) ;spell.reset
			SetInfoText("Resets all Passives and Actives, restore reduced Status Caps. Useful if you wish to change passives/actives.")
			
		elseIf(option == id23) ;spell.lusciousliquids
			int r1 = _s.SuH_rank_lusciousliquids
			int r2 = (_s.SuH_rank_lusciousliquids2 * 5)
			int x = 0
			if r1 > 0
				x = Math.Floor(r1 * (_s.SuH_PCSdpoint * 0.1))
			endIf
			SetInfoText("Sperm and Milk heals "+x+" Health/Magicka/Stamina and gain "+r2+"% more Fluid Bonus when consuming Sexual Fluids. [Affected by Desire Rating]")
		elseIf(option == id24) ;spell.lusciousliquidsrank
			SetInfoText("-20 Health Cap, +(10% Desire) Health/Magicka/Stamina Recovered")
		elseIf(option == id25) ;spell.lusciousliquidsrank2
			SetInfoText("-10 Stamina Cap, +5% Fluid Bonus Gained")
			
		elseif(option == id40) ;spell.capexcel
			int x = Math.Floor((_s.SuH_PCSbpoint * 0.2) * _s.SuH_rank_capexcel)
			string m = ""
			if _s.SuH_rank_capexcelplus > 0
				m = " Cap Excel+ is unlocked, while Sex Bonus is active Status won't decay."
			endIf
			SetInfoText("Exceed the Status Cap by "+x+" with absorption and slow its decay by "+_s.SuH_rank_capexcel2+" seconds."+m+" [Note : Status beyond your normal cap will decay over-time (1 second + Cap Excel's Effect) and convert into SkillXP] [Affected by Body Rating]")
		elseif(option == id41) ;spell.capexcelrank
			SetInfoText("-15 Health/Magicka/Stamina Cap, +(20% Body) Cap Excel capabilities")
		elseif(option == id42) ;spell.capexcelrank2
			SetInfoText("-10 Health/Magicka/Stamina Cap, +1sec Decay Delay")
		elseif(option == id29) ;spell.SuH_rank_capexcelplus
			SetInfoText("-60 Magicka/Stamina Cap to unlock, while unlocked Status exceding your Succubus' Status Cap won't decay while Sex Bonus Time is active")
			
		elseIf(option == id26) ;spell.formalbeauty
			int r1 = _s.SuH_rank_formalbeauty as int
			int x = 0
			if r1 > 0
				x = Math.Floor(r1 * (_s.SuH_PCSdpoint * 0.05))
			endIf
			SetInfoText("While Sex Bonus Time is active, restore "+x+" Health every 5 seconds. [Affected by Desire Rating]")
		elseIf(option == id27) ;spell.formalbeautyrank
			SetInfoText("-25 Health Cap, +(5% Desire) Health recovered every 5 seconds.")
			
		elseIf(option == id33) ;spell.selfindulgent
			int x = (_s.SuH_rank_selfstacker * 5)
			string m = ""
			if _s.SuH_rank_selfstackerplus > 0
				m = " Self Indulgent+ Unlocked : Gain Sex Bonus in solo acts. "
			endIf
			SetInfoText("Gain "+x+"% more Sex Bonus Time."+m)
		elseIf(option == id34) ;spell.selfstackerrank
			SetInfoText("-10 Stamina Cap, +5% more Sex Bonus Time Gained")
		elseIf(option == id43) ;spell.selfstackerrankplus
			SetInfoText("-120 Stamina Cap to unlock, While Unlocked Gain Sex Bonus in solo acts")
			
		elseIf(option == id35) ;spell.healthyabsorber
			int x = _s.SuH_rank_healthyabsorber
			int y = (x * 25)
			SetInfoText("Increase Health/Magicka/Stamina Recovered when Absorbing Status by "+y+"%.")
		elseIf(option == id36) ;spell.healthyabsorberrank
			SetInfoText("-5 Health/Magicka/Stamina Cap, +25% Healing/Recovery from Absorption")
			
		elseIf(option == id37) ;spell.perfectorgasm
			int x = _s.SuH_rank_perfectorgasm
			int z = (_s.SuH_rank_perfectorgasm2*5)
			SetInfoText("Increases the chance of a Rare Drop when bringing partners to an orgasm by "+x+"%. "+z+"% chance at receiving a death drop upon your Succubus' orgasm.")
		elseIf(option == id38) ;spell.perfectorgasmrank
			SetInfoText("-15 Magicka Cap, +1% Rare Drop Chance when bringing partners to orgasm.")
		elseIf(option == id39) ;spell.perfectorgasmrank2
			SetInfoText("-15 Health/Magicka/Stamina Cap, +5% Death Drop Chance.")
		endIf
	
	elseif (CurrentPage == "Actives") ; Actives
		if(option == id1)
			int x = (5 + ((_s.SuH_rank_seducer * 10 ) + (_s.SuH_rank_sexualentice * 15)))
			int y = (110 - (_s.SuH_rank_sexualentice * 10)) ; Start at 100 cost, reduce by 10 each rank
			SetInfoText("Sexual Entice : Attempts to Seduce the target into a sexual act with the caster with a "+x+"% chance of success. Costs "+y+" Magicka when cast on a target.")
		elseif(option == id4)
			SetInfoText("-25 Health/Magicka/Stamina, increase Seduction Success Rate by 15% and reduce cost by 10 Magicka")
		elseif(option == id2)
			int x = (5 + ((_s.SuH_rank_seducer * 10) + (_s.SuH_rank_sexualenrage * 15)))
			int y = (45 - (_s.SuH_rank_sexualenrage * 5)) ; Start at 40 cost, reduce by 5 each rank
			SetInfoText("Sexual Enrage : Attempts to Seduce the target into assaulting the caster with a "+x+"% chance of success. Costs "+y+" Health when cast on a target.")
		elseif(option == id5)
			SetInfoText("-25 Health/Magicka/Stamina, increase Seduction Success Rate by 15% and reduce cost by 5 Health")
		elseif(option == id3)
			SetInfoText("Sexual Embrace : Seduces a sleeping target with a 100% chance of success, has no effect on non-sleeping targets.")
		elseif(option == id6) ;spell.reset
			SetInfoText("Resets all Passives and Actives, restore reduced Status Caps. Useful if you wish to change passives/actives.")
		endIf
	
	elseif(CurrentPage == "Soul Pets") ; Soul Pets
		if(option == id0) ;pet.skill
			SetInfoText("Soul Pet Skill Level, increases XP gained by pets by 10% per-level. [Improve Soul Pet Skill Level by leveling pets]")
		elseif(option == id1) ;pet.activepet
			SetInfoText("Currently Active Pet set to follow your Succubus.")
		elseif(option == id2) ; selected pet
			SetInfoText("Currently Selected Pet in this MCM")
		elseif(option == id6) ; dismiss pet
			SetInfoText("Dismiss the Active pet and have them stop following your Succubus [NOTE : Follower Management Mods may keep the pet following you]")
		elseif(option == id5) ; summon pet
			SetInfoText("Summon the selected pet and make it the Active pet")
		elseif(option == id7) ; unsummon pet
			SetInfoText("Unsummon the currently selected pet, returning them to the Succubus Realm")
		elseif(option == id8) ; rename pet
			SetInfoText("Rename the currently selected pet. [Names will only show up in the MCM and in notifications, useful for sorting your pets]")
		elseif(option == id9) ; swap pet slots
			SetInfoText("Swap your currently selected pet with another pet slot. Used to re-organize your pets however you please.")
		elseif(option == id4) ; delete pet
			SetInfoText("Remove / Delete the currently selected pet. [CAN NOT BE UNDONE!!! This will remove the selected pet from both the MCM and the game world. If you use Follower Management Mods, dismiss them in Succubus Heart and delete them from the Follower Management Mod before deleting the pet here in the MCM]")
		elseif(option == id10) ; pet active status
			SetInfoText("The selected pet's active status. [Summoned : Currently in the game world] [Returned : Resting in the Succubus Realm]")
		elseif(option == id11) ; pet traits
			SetInfoText("Special Pet Traits which changes their stats or behavior. [Pets have a chance to earn Traits every level with an increasing chance the higher the level. Pets can only have up-to 3 Traits. Traits are permanent and can not be removed.]")
		elseif(option == id12 || option == id13 || option == id14) ; pet trait slot
			int x = 0
			if option == id12 ; Get the correct pet trait from the appropriate slot
				x = _s.SuH_pettrait0[petselectedslot]
			elseif option == id13
				x = _s.SuH_pettrait1[petselectedslot]
			else
				x = _s.SuH_pettrait2[petselectedslot]
			endIf
			SetInfoText(_f.PetGetTraitName(traitnum=x, descrip=true))
		elseif(option == id15) ; pet remove trait
			SetInfoText("Spend 30 Blood Chips to remove a Pet Trait. [Removed Traits can still be re-learned when the pet gains a new trait.]")
		endIf	
	elseif(CurrentPage == "Titles") ; Titles
		if(option == id0)
			int x = ((_s.SuH_title_succubus * 100) - _s.SuH_titlexp_succubus)
			SetInfoText("[XP Till Next Rank : "+x+"] Be a good Succubus and you'll get the recognition you crave.")
		elseif(option == id1)
			int x = ((_s.SuH_title_drinker * 100) - _s.SuH_titlexp_drinker)
			SetInfoText("[XP Till Next Rank : "+x+"] A dry throat makes for a dry night.")
		elseif(option == id2)
			int x = ((_s.SuH_title_friendly * 100) - _s.SuH_titlexp_friendly)
			SetInfoText("[XP Till Next Rank : "+x+"] Sometimes it feels good to put your evil side away for a bit.")
		elseif(option == id4)
			int x = ((_s.SuH_title_pettrain * 100) - _s.SuH_titlexp_pettrain)
			SetInfoText("[XP Till Next Rank : "+x+"] Hold the leash tight and enjoy your subordinate.")
		elseif(option == id8)
			int x = ((_s.SuH_title_offeritem * 100) - _s.SuH_titlexp_offeritem)
			SetInfoText("[XP Till Next Rank : "+x+"] Unseen powers gift those who gift first.")
		elseif(option == id9)
			int x = ((_s.SuH_title_seducer * 100) - _s.SuH_titlexp_seducer)
			SetInfoText("[XP Till Next Rank : "+x+"] Learning your alluring presence has its rewards.")
			
		elseif(option == id3)
			if _s.SuH_title_pethit < 20
				SetInfoText("This title better stay unknown.")
			else
				SetInfoText("You've been abusing your pets far too much for this to be an accident, stop it before I call pet protection services!")
			endIf
		elseif(option == id5)
			if _s.SuH_title_realmvisit < 1
				SetInfoText("Search deep inside to return somewhere familiar, yet new.")
			else
				SetInfoText("Connected through your soul to the other realm.")
			endIf
		elseif(option == id6)
			if _s.SuH_title_drainkilled < 1
				SetInfoText("As they close their eyes for the last time, leave a lasting smile.")
			else
				SetInfoText("Left a smile as their eyes closed one last time.")
			endIf
		elseif(option == id7)
			if _s.SuH_title_fedchest < 10000
				SetInfoText("They make not a sound, yet their stomach hungers ever more, and you can not help but satisfy this hunger.")
			else
				SetInfoText("You made many sacrifices to the gluttonous chest, and yet it still hungers for more, never satisfied with your service. You've become a wiling servant to the endless stomach.")
			endIf
		elseif(option == id10)
			if _s.SuH_title_statdown < 1
				SetInfoText("For the pursuit of ultimate power, self sacrifice is the only option.")
			else
				SetInfoText("Sacrificing so much in the name of power may have some call you a demon, others have seen your true sacrifice and call you The Devil.")
			endIf
		endIf
	
	elseif (CurrentPage == "Settings") ; Settings
	
		If(option == id0) ;effectmulti
			SetInfoText("Change how much HeartXP is earned by a percentage. [Increase for faster progression, decrease for slower progression] [Default : 100%]")
		elseIf(option == id1) ;setnpcabsorb
			SetInfoText("All NPCS : Allows all NPCs to have their Status drained, reducing their Max Health/Magicka/Stamina.\nNo NPCs : Prevent NPCs having their Status drained.\nNon-Allies : NPCs with a high relationship rank (Ally) will not have their Status drained. (Hostile Only checks if they are naturally hostile)\n[Without NPC drain enabled you won't be able to drain any status through sex or drain abilities unless 'Always Get Drain Benefits' is also enabled] [Default : All NPCs]")
		elseif(option == id4) ; drainkill
			SetInfoText("While Enabled : Allows Drain to kill partners if their Health reaches zero. [Default : Always]")
		elseIf(option == id5) ; status.alwaysdrainkill
			SetInfoText("While Enabled : Drain will skip any Health checks and always trigger a kill if drain settings allow and the NPC is not protected/essential. [Default : Disabled]")
		elseIf(option == id6) ; SuH_SETdrainresetorgasm
			SetInfoText("While Enabled : Drain will 'reset' to 100% when the player's succubus orgasms, then proceed to decrease as normal again. [Intended as an option for players using Separate Orgasms and long animation times] [Default : Disabled]")
			
		elseIf(option == id7)  ;calmaura
			SetInfoText("While Enabled : While the player is in a Sex Act a calming aura will attempt to stop any nearby combat. [May not work in all situations depending on your mod set-up and in rare occasions may break AI] [Default : Disabled]")
		elseif(option == id12) ; hostilevigilfaction
			SetInfoText("While Enabled : Vigilant of Stendarr will be hostile to the player. [Default : Disabled]")
			
		elseif(option == id8) ; status.deathdrops
			SetInfoText("While Enabled : Characters will have a 'soul' item drop put into their inventory when they die. [Soul Items are used for Succubus Heart progression] [Default : Enabled]")
			
		elseIf(option == id10) ; SuH_PCSarousalgainmulti
			SetInfoText("Change Lust Gained [Lust increases naturally over-time and in specific scenarios. High Lust gives more HeartXP but has side effects] [Default : 100%]")
		elseIf(option == id18) ; SuH_SETarousaldefect
			SetInfoText("While enabled, certain defects will apply when at higher Lust states. [Default : Enabled]")
			
		elseIf(option == id13) ;endactonatk
			SetInfoText("While Enabled : Will attempt to end sex acts when the acting NPC or Player is attacked. [Can cause issues with some animations not ending properly] [Default : Disabled]")
		elseIf(option == id14) ;status.clearactor
			SetInfoText("While Enabled : Attempts to remove any stuck projectiles from the player when starting a sex act. [May remove some mod-added visual effects] [Default : Disabled]")
		elseif(option == id15) ;status.malehomo
			SetInfoText("While Enabled : Allows Male/Male Acts to be triggered through Succubus Heart. [Has no effect on other mods] [Default : Disabled]")
		elseif(option == id16) ;status.femalehomo
			SetInfoText("While Enabled : Allows Female/Female Acts to be triggered through Succubus Heart. [Has no effect on other mods] [Default : Enabled]")
		elseIf(option == id17) ;status.restricact
			SetInfoText("While Enabled : Female aggressors will use cowgirl animations. [Has no effect on other mods] [Default : Disabled]")
		elseif(option == id43) ;SuH_SETslaifix
			SetInfoText("While Enabled : Attempts to fix SexLab breaking NPC's AI after the end of an act. Most noticeable when using Combat Seduction. [Caused by an AI Package getting stuck on the NPC, may not always work] [Default : Enabled]")
			
		elseif(option == id19) ;status.petspells
			SetInfoText("When Enabled : Adds Soul Pet's base function spells to the player. [When Disabled : Removes Soul Pet's base spells] [Only disable if you don't want to use Soul Pets]  [Default : Enabled]")
		elseif(option == id20) ;status.removepet
			SetInfoText("While Enabled : Soul Pets are removed and unregistered when they die. [Same as removing them manually in the MCM] [Default : Enabled]")
		elseif(option == id3) ;status.dismisspet
			SetInfoText("While Enabled : Soul Pets will be dismissed instead of unsummoned if you have an actively following Soul Pet. This means they will stay spawned and active without following. [Default : Disabled]")
		elseif(option == id9) ;status.petstayfollowing
			SetInfoText("While Enabled : Soul Pets will not 'unfollow' the player, allowing some Follower Manager Mods to take over completely. [Only recommended if you're using a Follower Management Mod, does not fix all issues and may still cause errors. Not recommended while using the vanilla game's follower system.] [Default : Disabled]")
		elseif(option == id11) ;SuH_SETtraitwontkill
			SetInfoText("While Enabled : Traits which cause Health damage during SexLab acts will try not to kill their partner. [Default : Disabled]")
			
		elseif(option == id21) ;status.combatseduction
			SetInfoText("While Enabled : Enables the Combat Seduction Feature. When characters drop below the set thresholds they will submit to their attacker, starting a sex act. [Light weight and fully integrated Combat Submission mod, keep disabled if you use any other Combat Submission mods] [Default : Disabled]")
		elseif(option == id22) ;status.cscooldown
			SetInfoText("Characters won't submit to their attackers for the set duration after a sex act. [Default : 10 Seconds]")
			
		elseif(option == id23) ;pctonpchealth
			SetInfoText("While above 0% : When the Player is below the set Health percentage they will submit to attacking NPCs. [Default : 30%]")
		elseif(option == id24) ;pctonpchealthmin
			SetInfoText("While above 0 : When the Player is below the set Health amount they will submit to attacking NPCs. [Default : 20]")
		elseif(option == id25) ;pctonpcstamina
			SetInfoText("While above 0% : When the Player is below the set Stamina percentage they will submit to attacking NPCs. [Default : 30%]")
		elseif(option == id26) ;npctopchealth
			SetInfoText("While above 0% : When an NPC is below the set Health percentage they will submit to the Player when attacked. [Default : 30%]")
		elseif(option == id27) ;npctolchealthmin
			SetInfoText("While above 0 : When an NPC is below the set Health amount they will submit to the Player when attacked. [Default : 20]")
		elseif(option == id28) ;npctonpchealth
			SetInfoText("While above 0% : When an NPC is below the set Health percentage they will submit to the other NPCs when attacked. [Default : 30%]")
		elseif(option == id29) ;npctonpchealthmin
			SetInfoText("While above 0 : When an NPC is below the set Health amount they will submit to the other NPCs when attacked. [Default : 20]")
			
		elseIf(option == id30) ;dom
			SetInfoText("While Enabled : Enables Death Override Mode. Instead of dying the player will respawn in the Succubus Realm. DO NOT disable while any SexLab animations are going as it can cause the player character to get stuck in a DeferredKill state. [Keep disabled if you use any other Death Alternative mods] [Default : Disabled]")
		elseIf(option == id31) ;status.randomdeathspawm
			SetInfoText("While Enabled : When returning after DOM respawns the Succubus in the Succubus Realm, force the return point to either be random or the last entrance based on this setting. [Random Respawn is pulled from a short list of possible locations] [Default : Last Entrance]")
		elseIf(option == id32) ;status.loseitems
			SetInfoText("While Enabled : Player loses all non-quest items when reviving with DOM [Items can be re-purchased through Tali in the Succubus Realm] [Default : Enabled]")
		elseIf(option == id33) ;status.losegold
			SetInfoText("While Enabled : Player loses all Gold when reviving with DOM. [Default : Disabled]")
		elseIf(option == id34) ;status.losebloodchips
			SetInfoText("While Enabled : Player loses all Blood Chips when reviving with DOM. [Default : Disabled]")
		elseIf(option == id35) ;status.loseequip
			SetInfoText("While Enabled : Player's equipped items will be destroyed when reviving with DOM, granting HeartXP based on the items destroyed. [Items can't be re-purchased from Tali] [Default : Disabled]")
		elseIf(option == id36) ;SETrevivecost
			SetInfoText("While above 0% : Player will lose the set percentage of Max Status when reviving with DOM. [Value can't drop below 1, 100% will result in 1 Max Status remaining] [Default : 50%]")
		elseif(option == id37) ;status.csbleedoutdelay
			SetInfoText("Sets the delay before the Player is revived with DOM. [Increase if you experience high script lag, higher values can help animations have enough time to trigger] [Default : 5]")
		elseIf(option == id38) ; neverdie
			SetInfoText("While Enabled : Player will revive on the spot rather than returning to the Succubus Realm. [Default : Disabled]")
		elseIf(option == id39) ; SuH_SETmilkdistribute
			SetInfoText("While Enabled : When orgasming, Female characters will give Breast Milk to their partners. [Default : Disabled]")
		elseIf(option == id40) ; SuH_SETdynaspid
			SetInfoText("Use SPID to apply dynamic scripts, requires 'Spell Perk Item Distributor (SPID)' to be installed. [When changing this setting, Save then reload immediately to avoid issues. If disabled, Succubus Heart will revert to a much more heavy script cloaks system] [Default : Enabled]")
		elseIf(option == id46) ; SuH_SETonlyframepref
			SetInfoText("While Enabled : Will only use the set Framework Preference when calculating effects for Succubus Heart so that only animations from the specified framework apply drain/XP/ect. Disable to allow multiple frameworks to trigger events. [Useful if one framework has bugs, is incompatible, or doesn't work properly.] [Default : Disabled]")
		elseIf(option == id41) ; SuH_SETspermdistribute
			SetInfoText("While Enabled : When orgasming, Male characters will give Sperm to their partners. [Default : Enabled]")
		elseIf(option == id2) ; SuH_SETalwaysabsorbbenefit
			SetInfoText("While Enabled : Player's Succubus will still gain drain benefits even if the target isn't actually drained. Useful when 'Drain Affects NPC Status' is disabled. [This option heavily affects balance and isn't recommended] [Default : Disabled]")
		elseIf(option == id42) ; SuH_SETdrainvisualinact
			SetInfoText("While Enabled : Display drain visuals occasionally while in SexLab animations. [Default : Disabled]")
		elseIf(option == id44) ; SuH_SETpreventactdeath
			SetInfoText("While Enabled : Delays any deaths during sex acts and instead triggers them after an act ends instead. DO NOT disable this setting while an animation is currently active as it will cause any acting actor to be stuck in a deferredkill state. (Will apply to the player while DOM is enabled regardless of this setting to prevent major issues) [Default : Enabled]")
		elseIf(option == id45) ; SuH_SETrealmspellcost
			SetInfoText("While Enabled : Succubus Realm -Teleport- and Succubus Realm -Chest- will cost Max Magicka to cast. (This cost scales with level, -Teleport- costs 3 per Player Level, -Chest- costs 2 per Player Level) [Default : Enabled]")
		endIf
		
	elseif(CurrentPage == "Help") ; Help
	
		if(option == id32) ; Discord Link
			SetInfoText("Join The Broken Chatbox Discord! Here you can get updates, assistance, or just hang out! [https://discord.gg/h3vB7S4FEw]")
			
		elseif(option == id12) ;help.hungrychest
			SetInfoText("I was exploring the Succubus Realm when I came accross a suspicious chest! I felt I should put something inside, but I shouldn't have put my favorite hat in there...")
		elseif(option == id30) ;help.petuse
			SetInfoText("He's just so useful and always there for me when I need him most! I forgot my backup potions at home so I called him over and after a bit of huff and puff, bam! He had me slurping down some healing, right when I needed it! Am I... am I falling in love..?")
		elseif(option == id8) ;help.seduction
			SetInfoText("I begged and begged but no one would feed me! That was until I found a stressed guard taking a nap, a dream so pleasent it was impossible not to take a feast..")
		elseif(option == id31) ;help.seduction
			SetInfoText("The sheer amount of rewards for my seductive body was becoming difficult to manage, so I placed them as an offering. In return, they blessed me with a solution I never expected!")
			
		elseif(option == id13) ; Status
			SetInfoText("General term for Health, Magicka, and Stamina")
		elseif(option == id14) ; MaxStatus
			SetInfoText("Current Max Health, Magicka, or Stamina your character can heal too, independant of Status Cap and Drain. (Ex. With a Max Status of 150 Health, you can heal up-to 150 Health.)")
		elseif(option == id15) ; StatusCap
			SetInfoText("Highest Health, Magicka, or Stamina your character can Drain too. Your Max Status can't stay above this value. (Ex. If your Max Status is 120 but your Status Cap is 150, you can drain an additional 30 status, bringing your Max Status up-to 150)")
		elseif(option == id16) ; HeartXP
			SetInfoText("Succubus Heart Experience gained through Succubus Heart activities such as sexual acts, consuming sperm/milk, or through passives and items. HeartXP is used to enhance your Native Succubus Stats through the Heart Levels MCM or upgrade various features. (This is your main progression XP)")
		elseif(option == id17) ; SkillXP
			SetInfoText("Skill Experience earned through Succubus Heart activities, such as draining beyond your Status Cap or utilizing Passives/Actives. SkillXP can be spend in the Skill Levels MCM to level up vanilla skills.")
		elseif(option == id18) ; SexBonusTime
			SetInfoText("Temporary buffs timer that increases during sex acts and decreases when not in a sex act. Certain Passive/Active abilities will use this to determine their effect. [Uses in-game time]")
		elseif(option == id19) ; FluidBonusTime
			SetInfoText("Temporary buffs timer that increases when consuming Sperm or Breast Milk and doesn't decrease while in a sex act. Certain Passive/Active abilities will use this to determine their effect. [Uses in-game time]")
		elseif(option == id20) ; Sex Act
			SetInfoText("Refers to Any Sex Animation as opposed to defining a specific type of sex act or animation. Only includes those managed by SexLab.")
			
		elseif(option == id21) ; Status
			SetInfoText("View key stats related to your Status, Succubus Abilities, and the mod's current state. Can also set overrides and lock various stats.")
		elseif(option == id22) ; Heart Levels
			SetInfoText("Use HeartXP to enhance your native Succubus Stats. Earn HeartXP through Succubus Heart activities such as draining enemies or satisfying your desires.")
		elseif(option == id23) ; Skill Levels
			SetInfoText("Spend Skill Points you've earned through Succubus Heart to level up vanilla skills. Earn Skill Point XP through Succubus Heart activities, such as draining beyond your Status Cap, and, when enough is accumulated, Skill Points will be generated.")
		elseif(option == id24) ; Passives
			SetInfoText("Spend/Decrease Status Caps to unlock or strengthen your Passive Succubus Abilities. Passive Abilities gain additional bonuses based on your BDSM Rating. BDSM Rating is improved when increasing Heart Levels.")
		elseif(option == id25) ; Actives
			SetInfoText("Spend/Decrease Status Caps to unlock or strengthen your Active Succubus Abilities. Active Abilities gain additional bonuses based on your BDSM Rating. BDSM Rating is improved when increasing Heart Levels.")
		elseif(option == id26) ; Soul Pets
			SetInfoText("MCM for managing your Soul Pets. When souls have been replicated they'll show up here, select their slot for various options. Soul Pets will level up and strengthen through gameplay.")
		elseif(option == id28) ; Titles
			SetInfoText("Earn Reputaion through various activities for bonus HeartXP.")
		elseif(option == id29) ; Help
			SetInfoText("This MCM menu stores general information and help articles. If you're having issues understanding mechanics or want to check what various terms refer to, check here! If you don't find help here you can still join the Discord channel for further assistance!")
		
		elseif(option == id0) ;help.drain
			SetInfoText("With the powers of a succubus, the player will be able to Drain Max Status from their partners! This will decrease the partner's Max Health/Magicka/Stamina and instead give it to the player character. Drain in the same sex acts will have a decaying efficiency, each time reducing the effect by 20%. This decay effect resets every Sex Act, so go find more partners!")
		elseif(option == id11) ;help.arousal
			SetInfoText("Your Succubus will slowly become aroused over time and through specific actions. As Lust increases your Succubus will experience withdrawl with debuffs and negative side effects, however, finally satisfying their desires will offer larger bonuses at higher Lust. Lust works in tiers, at and below 100% your Succubus opporates at full capacity, at 150% your Succubus starts to experience Withdrawl with negative side effects, beyond 200% can become dangerous...")
		elseif(option == id3) ;help.xp
			SetInfoText("Your main progression experience, HeartXP, is earned in Sex Acts based on how long the animation lasts with bonuses that can be applied to earn even more HeartXP. HeartXP is used to level Native Succubus Abiltiies in the Heart Levels menu, making your succubus stronger!")
		elseif(option == id4) ;help.sp
			SetInfoText("SkillXP is earned through special conditions, such as draining Status when you're already at your current Status Cap or through passives. SkillXP can be spent to level up vanilla skills in the Skill Levels menu.")
		elseif(option == id1) ;help.drops
			SetInfoText("Special drops can be obtained when a character orgasms or dies (I know, both sides of the isle). On orgasm their partner may recieve sexual fluids based on their gender with a small chance for rare varients. Death drops are 'soul' items added to a character's inventory when they die. Both can be used to enhance stats or gain additional HeartXP, SkillXP, ect.")
		elseif(option == id5) ;help.bdsm
			SetInfoText("When improving your Heart Levels your succubus will improve their BDSM Rating. the BodyDesireSoulMind Rating is used by passives/actives to determine and strengthen their effect (in other words, BDSM rating is how powerful passive/active abilities can be). These Passive abilities are always active and offer various effects, while Actives require a spell to use but can be quite powerful when leveled. Unlocking both Passives and Actives cost Status Cap.")
		elseif(option == id6) ;help.titles
			SetInfoText("Titles are a fun way to track how you play and unlock some bonus HeartXP. As different actions are performed they will tally up into a certain type of reputation stat. When certain milestones are met you'll unlock new titles and be granted bonus HeartXP upon upgrading them in the MCM. (Note : Titles are designed to be a fun additional mechanic and promote experimentation with differnt mechanics, but are in no way required and generaly only offer HeartXP as a reward)")
			
		elseif(option == id2) ;help.realm
			SetInfoText("The Succubus Realm is a small location that can be accessed and departed by using the 'Succubus Realm -Teleport-' Spell. This location offers several useful crafting stations, NPCs that offer items for sale, and more. Upon leaving with the spell you can return either directly back where you entered from or to another location presented in the menu. The Succubus Realm can act as almost a home-base of sorts with storage chests and mechanics, or be completely ignored.")
		elseif(option == id27) ; offeringsystem
			SetInfoText("In the Succubus Realm resides an Offering Chest. Placing certain items inside, like Blood Chips, will present an offering to the Succubus Goddesses. If the Goddesses accepts the offered amount the player Succubus will be rewarded with items. Some Succubus Items can also be merged using this system, placing large numbers of Succubus items may return an upgraded version. [Note : With DOM enabled, Offering rewards can include items lost when defeated, acting as an alternative to re-buying items back from tali.]")
		elseif(option == id34) ; fluidfountain
			SetInfoText("In the Succubus Realm there is a fountain which offers up daily sexual fluids (runs based on in-game time, so waiting 24 hours spawns more fluids to collct). This fountain can be upgraded to give more fluids using Blood Chips.")
		elseif(option == id35) ; talitable
			SetInfoText("In the Succubus Realm Tali has a worktable with a chest set next to it. When placing items in Tali's Worktable Chest, she will begin replicating items left in the chest and adding them to her shop and to the Offering System's reward pool. You can help Tali by leaving Blood Chips at her Worktable, allowing her to replicate things faster. (Note : Tali's worktable updates every in-game hour, removing items from the chest will apply changes on the next hourly update)")
		elseif(option == id7) ;help.pets
			SetInfoText("Soul Pets allows you to replicate nearly any NPC and use them as a companion. You can summon or desummon them on command, use them for combat or for pleasure, and as they're used they level up, unlocking special traits changing their stats and behavior. [Soul Pets is its own mod integrated into Succubus Heart]")
		elseif(option == id9) ;help.cs
			SetInfoText("Combat Seduction is a simple and light-weight Combat Submit mod (if you're already using a Combat Submission mod you'll want to leave this disabled). Combat Seductions makes characters submit to their attackers when their Status is low enough, triggering sex scenes. [Combat Seduction is functionally its own mod integrated into Succubus Heart]")
		elseif(option == id10) ;help.dom
			SetInfoText("Death Override Mode is a Death Alternative mod inspired by Rogue-lites. Instead of dying the player is revived in the Succubus Realm with the chosen side effects, by default equipment is removed and can re-purchased from Tali, an NPC in the Succubus Realm. By default the mod is designed to keep gold and levels as your primary progression with items and equipment being disposable, however the mod can be re-configured to work as the player chooses. [Death Override Mode is its own mod integrated into Succubus Heart]")
		endIf
	endIf
endEvent

;endofscript